/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementMaintenanceWindowAsync;
import com.oracle.bmc.fleetappsmanagement.model.MaintenanceWindow;
import com.oracle.bmc.fleetappsmanagement.model.MaintenanceWindowCollection;
import com.oracle.bmc.fleetappsmanagement.requests.CreateMaintenanceWindowRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeleteMaintenanceWindowRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetMaintenanceWindowRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListMaintenanceWindowsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdateMaintenanceWindowRequest;
import com.oracle.bmc.fleetappsmanagement.responses.CreateMaintenanceWindowResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeleteMaintenanceWindowResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetMaintenanceWindowResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListMaintenanceWindowsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdateMaintenanceWindowResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FleetAppsManagementMaintenanceWindowAsyncClient
extends BaseAsyncClient
implements FleetAppsManagementMaintenanceWindowAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FLEETAPPSMANAGEMENTMAINTENANCEWINDOW").serviceEndpointPrefix("").serviceEndpointTemplate("https://fams.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(FleetAppsManagementMaintenanceWindowAsyncClient.class);

    FleetAppsManagementMaintenanceWindowAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateMaintenanceWindowResponse> createMaintenanceWindow(CreateMaintenanceWindowRequest request, AsyncHandler<CreateMaintenanceWindowRequest, CreateMaintenanceWindowResponse> handler) {
        Objects.requireNonNull(request.getCreateMaintenanceWindowDetails(), "createMaintenanceWindowDetails is required");
        return this.clientCall(request, CreateMaintenanceWindowResponse::builder).logger(LOG, "createMaintenanceWindow").serviceDetails("FleetAppsManagementMaintenanceWindow", "CreateMaintenanceWindow", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/MaintenanceWindow/CreateMaintenanceWindow").method(Method.POST).requestBuilder(CreateMaintenanceWindowRequest::builder).basePath("/20230831").appendPathParam("maintenanceWindows").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MaintenanceWindow.class, CreateMaintenanceWindowResponse.Builder::maintenanceWindow).handleResponseHeaderString("etag", CreateMaintenanceWindowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateMaintenanceWindowResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteMaintenanceWindowResponse> deleteMaintenanceWindow(DeleteMaintenanceWindowRequest request, AsyncHandler<DeleteMaintenanceWindowRequest, DeleteMaintenanceWindowResponse> handler) {
        Validate.notBlank((String)request.getMaintenanceWindowId(), (String)"maintenanceWindowId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteMaintenanceWindowResponse::builder).logger(LOG, "deleteMaintenanceWindow").serviceDetails("FleetAppsManagementMaintenanceWindow", "DeleteMaintenanceWindow", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/MaintenanceWindow/DeleteMaintenanceWindow").method(Method.DELETE).requestBuilder(DeleteMaintenanceWindowRequest::builder).basePath("/20230831").appendPathParam("maintenanceWindows").appendPathParam(request.getMaintenanceWindowId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteMaintenanceWindowResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteMaintenanceWindowResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetMaintenanceWindowResponse> getMaintenanceWindow(GetMaintenanceWindowRequest request, AsyncHandler<GetMaintenanceWindowRequest, GetMaintenanceWindowResponse> handler) {
        Validate.notBlank((String)request.getMaintenanceWindowId(), (String)"maintenanceWindowId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetMaintenanceWindowResponse::builder).logger(LOG, "getMaintenanceWindow").serviceDetails("FleetAppsManagementMaintenanceWindow", "GetMaintenanceWindow", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/MaintenanceWindow/GetMaintenanceWindow").method(Method.GET).requestBuilder(GetMaintenanceWindowRequest::builder).basePath("/20230831").appendPathParam("maintenanceWindows").appendPathParam(request.getMaintenanceWindowId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MaintenanceWindow.class, GetMaintenanceWindowResponse.Builder::maintenanceWindow).handleResponseHeaderString("etag", GetMaintenanceWindowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMaintenanceWindowResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListMaintenanceWindowsResponse> listMaintenanceWindows(ListMaintenanceWindowsRequest request, AsyncHandler<ListMaintenanceWindowsRequest, ListMaintenanceWindowsResponse> handler) {
        return this.clientCall(request, ListMaintenanceWindowsResponse::builder).logger(LOG, "listMaintenanceWindows").serviceDetails("FleetAppsManagementMaintenanceWindow", "ListMaintenanceWindows", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/MaintenanceWindowCollection/ListMaintenanceWindows").method(Method.GET).requestBuilder(ListMaintenanceWindowsRequest::builder).basePath("/20230831").appendPathParam("maintenanceWindows").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("timeScheduleStartGreaterThanOrEqualTo", (Object)request.getTimeScheduleStartGreaterThanOrEqualTo()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MaintenanceWindowCollection.class, ListMaintenanceWindowsResponse.Builder::maintenanceWindowCollection).handleResponseHeaderString("opc-request-id", ListMaintenanceWindowsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMaintenanceWindowsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListMaintenanceWindowsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<UpdateMaintenanceWindowResponse> updateMaintenanceWindow(UpdateMaintenanceWindowRequest request, AsyncHandler<UpdateMaintenanceWindowRequest, UpdateMaintenanceWindowResponse> handler) {
        Validate.notBlank((String)request.getMaintenanceWindowId(), (String)"maintenanceWindowId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMaintenanceWindowDetails(), "updateMaintenanceWindowDetails is required");
        return this.clientCall(request, UpdateMaintenanceWindowResponse::builder).logger(LOG, "updateMaintenanceWindow").serviceDetails("FleetAppsManagementMaintenanceWindow", "UpdateMaintenanceWindow", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/MaintenanceWindow/UpdateMaintenanceWindow").method(Method.PUT).requestBuilder(UpdateMaintenanceWindowRequest::builder).basePath("/20230831").appendPathParam("maintenanceWindows").appendPathParam(request.getMaintenanceWindowId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateMaintenanceWindowResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateMaintenanceWindowResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)FleetAppsManagementMaintenanceWindowAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(FleetAppsManagementMaintenanceWindowAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)FleetAppsManagementMaintenanceWindowAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)FleetAppsManagementMaintenanceWindowAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)FleetAppsManagementMaintenanceWindowAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)FleetAppsManagementMaintenanceWindowAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FleetAppsManagementMaintenanceWindowAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FleetAppsManagementMaintenanceWindowAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "fleetappsmanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"fleetappsmanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public FleetAppsManagementMaintenanceWindowAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new FleetAppsManagementMaintenanceWindowAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

