/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementMaintenanceWindow;
import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementMaintenanceWindowPaginators;
import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementMaintenanceWindowWaiters;
import com.oracle.bmc.fleetappsmanagement.model.MaintenanceWindow;
import com.oracle.bmc.fleetappsmanagement.model.MaintenanceWindowCollection;
import com.oracle.bmc.fleetappsmanagement.requests.CreateMaintenanceWindowRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeleteMaintenanceWindowRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetMaintenanceWindowRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListMaintenanceWindowsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdateMaintenanceWindowRequest;
import com.oracle.bmc.fleetappsmanagement.responses.CreateMaintenanceWindowResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeleteMaintenanceWindowResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetMaintenanceWindowResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListMaintenanceWindowsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdateMaintenanceWindowResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FleetAppsManagementMaintenanceWindowClient
extends BaseSyncClient
implements FleetAppsManagementMaintenanceWindow {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FLEETAPPSMANAGEMENTMAINTENANCEWINDOW").serviceEndpointPrefix("").serviceEndpointTemplate("https://fams.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(FleetAppsManagementMaintenanceWindowClient.class);
    private final FleetAppsManagementMaintenanceWindowWaiters waiters;
    private final FleetAppsManagementMaintenanceWindowPaginators paginators;

    FleetAppsManagementMaintenanceWindowClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("FleetAppsManagementMaintenanceWindow-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new FleetAppsManagementMaintenanceWindowWaiters(executorService, this);
        this.paginators = new FleetAppsManagementMaintenanceWindowPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateMaintenanceWindowResponse createMaintenanceWindow(CreateMaintenanceWindowRequest request) {
        Objects.requireNonNull(request.getCreateMaintenanceWindowDetails(), "createMaintenanceWindowDetails is required");
        return (CreateMaintenanceWindowResponse)this.clientCall(request, CreateMaintenanceWindowResponse::builder).logger(LOG, "createMaintenanceWindow").serviceDetails("FleetAppsManagementMaintenanceWindow", "CreateMaintenanceWindow", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/MaintenanceWindow/CreateMaintenanceWindow").method(Method.POST).requestBuilder(CreateMaintenanceWindowRequest::builder).basePath("/20230831").appendPathParam("maintenanceWindows").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(MaintenanceWindow.class, CreateMaintenanceWindowResponse.Builder::maintenanceWindow).handleResponseHeaderString("etag", CreateMaintenanceWindowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateMaintenanceWindowResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteMaintenanceWindowResponse deleteMaintenanceWindow(DeleteMaintenanceWindowRequest request) {
        Validate.notBlank((String)request.getMaintenanceWindowId(), (String)"maintenanceWindowId must not be blank", (Object[])new Object[0]);
        return (DeleteMaintenanceWindowResponse)this.clientCall(request, DeleteMaintenanceWindowResponse::builder).logger(LOG, "deleteMaintenanceWindow").serviceDetails("FleetAppsManagementMaintenanceWindow", "DeleteMaintenanceWindow", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/MaintenanceWindow/DeleteMaintenanceWindow").method(Method.DELETE).requestBuilder(DeleteMaintenanceWindowRequest::builder).basePath("/20230831").appendPathParam("maintenanceWindows").appendPathParam(request.getMaintenanceWindowId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteMaintenanceWindowResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteMaintenanceWindowResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetMaintenanceWindowResponse getMaintenanceWindow(GetMaintenanceWindowRequest request) {
        Validate.notBlank((String)request.getMaintenanceWindowId(), (String)"maintenanceWindowId must not be blank", (Object[])new Object[0]);
        return (GetMaintenanceWindowResponse)this.clientCall(request, GetMaintenanceWindowResponse::builder).logger(LOG, "getMaintenanceWindow").serviceDetails("FleetAppsManagementMaintenanceWindow", "GetMaintenanceWindow", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/MaintenanceWindow/GetMaintenanceWindow").method(Method.GET).requestBuilder(GetMaintenanceWindowRequest::builder).basePath("/20230831").appendPathParam("maintenanceWindows").appendPathParam(request.getMaintenanceWindowId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(MaintenanceWindow.class, GetMaintenanceWindowResponse.Builder::maintenanceWindow).handleResponseHeaderString("etag", GetMaintenanceWindowResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMaintenanceWindowResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListMaintenanceWindowsResponse listMaintenanceWindows(ListMaintenanceWindowsRequest request) {
        return (ListMaintenanceWindowsResponse)this.clientCall(request, ListMaintenanceWindowsResponse::builder).logger(LOG, "listMaintenanceWindows").serviceDetails("FleetAppsManagementMaintenanceWindow", "ListMaintenanceWindows", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/MaintenanceWindowCollection/ListMaintenanceWindows").method(Method.GET).requestBuilder(ListMaintenanceWindowsRequest::builder).basePath("/20230831").appendPathParam("maintenanceWindows").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("timeScheduleStartGreaterThanOrEqualTo", (Object)request.getTimeScheduleStartGreaterThanOrEqualTo()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(MaintenanceWindowCollection.class, ListMaintenanceWindowsResponse.Builder::maintenanceWindowCollection).handleResponseHeaderString("opc-request-id", ListMaintenanceWindowsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMaintenanceWindowsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListMaintenanceWindowsResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public UpdateMaintenanceWindowResponse updateMaintenanceWindow(UpdateMaintenanceWindowRequest request) {
        Validate.notBlank((String)request.getMaintenanceWindowId(), (String)"maintenanceWindowId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMaintenanceWindowDetails(), "updateMaintenanceWindowDetails is required");
        return (UpdateMaintenanceWindowResponse)this.clientCall(request, UpdateMaintenanceWindowResponse::builder).logger(LOG, "updateMaintenanceWindow").serviceDetails("FleetAppsManagementMaintenanceWindow", "UpdateMaintenanceWindow", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/MaintenanceWindow/UpdateMaintenanceWindow").method(Method.PUT).requestBuilder(UpdateMaintenanceWindowRequest::builder).basePath("/20230831").appendPathParam("maintenanceWindows").appendPathParam(request.getMaintenanceWindowId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateMaintenanceWindowResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateMaintenanceWindowResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public FleetAppsManagementMaintenanceWindowWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public FleetAppsManagementMaintenanceWindowPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)FleetAppsManagementMaintenanceWindowClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(FleetAppsManagementMaintenanceWindowClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)FleetAppsManagementMaintenanceWindowClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)FleetAppsManagementMaintenanceWindowClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)FleetAppsManagementMaintenanceWindowClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)FleetAppsManagementMaintenanceWindowClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FleetAppsManagementMaintenanceWindowClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FleetAppsManagementMaintenanceWindowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FleetAppsManagementMaintenanceWindowClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FleetAppsManagementMaintenanceWindowClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "fleetappsmanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"fleetappsmanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public FleetAppsManagementMaintenanceWindowClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new FleetAppsManagementMaintenanceWindowClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

