/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementMaintenanceWindow;
import com.oracle.bmc.fleetappsmanagement.model.MaintenanceWindow;
import com.oracle.bmc.fleetappsmanagement.requests.GetMaintenanceWindowRequest;
import com.oracle.bmc.fleetappsmanagement.responses.GetMaintenanceWindowResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class FleetAppsManagementMaintenanceWindowWaiters {
    private final ExecutorService executorService;
    private final FleetAppsManagementMaintenanceWindow client;

    public FleetAppsManagementMaintenanceWindowWaiters(ExecutorService executorService, FleetAppsManagementMaintenanceWindow client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetMaintenanceWindowRequest, GetMaintenanceWindowResponse> forMaintenanceWindow(GetMaintenanceWindowRequest request, MaintenanceWindow.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMaintenanceWindow(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMaintenanceWindowRequest, GetMaintenanceWindowResponse> forMaintenanceWindow(GetMaintenanceWindowRequest request, MaintenanceWindow.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMaintenanceWindow(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMaintenanceWindowRequest, GetMaintenanceWindowResponse> forMaintenanceWindow(GetMaintenanceWindowRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MaintenanceWindow.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMaintenanceWindow(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMaintenanceWindowRequest, GetMaintenanceWindowResponse> forMaintenanceWindow(BmcGenericWaiter waiter, GetMaintenanceWindowRequest request, MaintenanceWindow.LifecycleState ... targetStates) {
        final HashSet<MaintenanceWindow.LifecycleState> targetStatesSet = new HashSet<MaintenanceWindow.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMaintenanceWindowRequest, GetMaintenanceWindowResponse>(){

            @Override
            public GetMaintenanceWindowResponse apply(GetMaintenanceWindowRequest request) {
                return FleetAppsManagementMaintenanceWindowWaiters.this.client.getMaintenanceWindow(request);
            }
        }, (Predicate)new Predicate<GetMaintenanceWindowResponse>(){

            @Override
            public boolean test(GetMaintenanceWindowResponse response) {
                return targetStatesSet.contains((Object)response.getMaintenanceWindow().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)MaintenanceWindow.LifecycleState.Deleted)), (Object)request);
    }
}

