/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementOperationsAsync;
import com.oracle.bmc.fleetappsmanagement.model.ComplianceRecordAggregationCollection;
import com.oracle.bmc.fleetappsmanagement.model.ComplianceRecordCollection;
import com.oracle.bmc.fleetappsmanagement.model.Execution;
import com.oracle.bmc.fleetappsmanagement.model.ExecutionCollection;
import com.oracle.bmc.fleetappsmanagement.model.JobActivity;
import com.oracle.bmc.fleetappsmanagement.model.ManagedEntityAggregationCollection;
import com.oracle.bmc.fleetappsmanagement.model.Patch;
import com.oracle.bmc.fleetappsmanagement.model.PatchCollection;
import com.oracle.bmc.fleetappsmanagement.model.ResourceCollection;
import com.oracle.bmc.fleetappsmanagement.model.ScheduledFleetCollection;
import com.oracle.bmc.fleetappsmanagement.model.SchedulerDefinition;
import com.oracle.bmc.fleetappsmanagement.model.SchedulerDefinitionCollection;
import com.oracle.bmc.fleetappsmanagement.model.SchedulerJob;
import com.oracle.bmc.fleetappsmanagement.model.SchedulerJobAggregationCollection;
import com.oracle.bmc.fleetappsmanagement.model.SchedulerJobCollection;
import com.oracle.bmc.fleetappsmanagement.model.StepCollection;
import com.oracle.bmc.fleetappsmanagement.requests.CreatePatchRequest;
import com.oracle.bmc.fleetappsmanagement.requests.CreateSchedulerDefinitionRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeletePatchRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeleteSchedulerDefinitionRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeleteSchedulerJobRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ExportComplianceReportRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetExecutionRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetJobActivityRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetPatchRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetSchedulerDefinitionRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetSchedulerJobRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListComplianceRecordsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListExecutionsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListPatchesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListResourcesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListScheduledFleetsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListSchedulerDefinitionsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListSchedulerJobsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListStepsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ManageJobExecutionRequest;
import com.oracle.bmc.fleetappsmanagement.requests.SummarizeComplianceRecordCountsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.SummarizeManagedEntityCountsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.SummarizeSchedulerJobCountsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdatePatchRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdateSchedulerDefinitionRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdateSchedulerJobRequest;
import com.oracle.bmc.fleetappsmanagement.responses.CreatePatchResponse;
import com.oracle.bmc.fleetappsmanagement.responses.CreateSchedulerDefinitionResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeletePatchResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeleteSchedulerDefinitionResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeleteSchedulerJobResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ExportComplianceReportResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetExecutionResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetJobActivityResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetPatchResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetSchedulerDefinitionResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetSchedulerJobResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListComplianceRecordsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListExecutionsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListPatchesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListResourcesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListScheduledFleetsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListSchedulerDefinitionsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListSchedulerJobsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListStepsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ManageJobExecutionResponse;
import com.oracle.bmc.fleetappsmanagement.responses.SummarizeComplianceRecordCountsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.SummarizeManagedEntityCountsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.SummarizeSchedulerJobCountsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdatePatchResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdateSchedulerDefinitionResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdateSchedulerJobResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FleetAppsManagementOperationsAsyncClient
extends BaseAsyncClient
implements FleetAppsManagementOperationsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FLEETAPPSMANAGEMENTOPERATIONS").serviceEndpointPrefix("").serviceEndpointTemplate("https://fams.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(FleetAppsManagementOperationsAsyncClient.class);

    FleetAppsManagementOperationsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(builder, authenticationDetailsProvider, true);
    }

    FleetAppsManagementOperationsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"FleetAppsManagementOperationsAsyncClient", (String)"exportComplianceReport"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreatePatchResponse> createPatch(CreatePatchRequest request, AsyncHandler<CreatePatchRequest, CreatePatchResponse> handler) {
        Objects.requireNonNull(request.getCreatePatchDetails(), "createPatchDetails is required");
        return this.clientCall(request, CreatePatchResponse::builder).logger(LOG, "createPatch").serviceDetails("FleetAppsManagementOperations", "CreatePatch", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Patch/CreatePatch").method(Method.POST).requestBuilder(CreatePatchRequest::builder).basePath("/20230831").appendPathParam("patches").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Patch.class, CreatePatchResponse.Builder::patch).handleResponseHeaderString("etag", CreatePatchResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePatchResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateSchedulerDefinitionResponse> createSchedulerDefinition(CreateSchedulerDefinitionRequest request, AsyncHandler<CreateSchedulerDefinitionRequest, CreateSchedulerDefinitionResponse> handler) {
        Objects.requireNonNull(request.getCreateSchedulerDefinitionDetails(), "createSchedulerDefinitionDetails is required");
        return this.clientCall(request, CreateSchedulerDefinitionResponse::builder).logger(LOG, "createSchedulerDefinition").serviceDetails("FleetAppsManagementOperations", "CreateSchedulerDefinition", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/SchedulerDefinition/CreateSchedulerDefinition").method(Method.POST).requestBuilder(CreateSchedulerDefinitionRequest::builder).basePath("/20230831").appendPathParam("schedulerDefinitions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SchedulerDefinition.class, CreateSchedulerDefinitionResponse.Builder::schedulerDefinition).handleResponseHeaderString("location", CreateSchedulerDefinitionResponse.Builder::location).handleResponseHeaderString("content-location", CreateSchedulerDefinitionResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateSchedulerDefinitionResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateSchedulerDefinitionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateSchedulerDefinitionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePatchResponse> deletePatch(DeletePatchRequest request, AsyncHandler<DeletePatchRequest, DeletePatchResponse> handler) {
        Validate.notBlank((String)request.getPatchId(), (String)"patchId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePatchResponse::builder).logger(LOG, "deletePatch").serviceDetails("FleetAppsManagementOperations", "DeletePatch", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Patch/DeletePatch").method(Method.DELETE).requestBuilder(DeletePatchRequest::builder).basePath("/20230831").appendPathParam("patches").appendPathParam(request.getPatchId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeletePatchResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeletePatchResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSchedulerDefinitionResponse> deleteSchedulerDefinition(DeleteSchedulerDefinitionRequest request, AsyncHandler<DeleteSchedulerDefinitionRequest, DeleteSchedulerDefinitionResponse> handler) {
        Validate.notBlank((String)request.getSchedulerDefinitionId(), (String)"schedulerDefinitionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSchedulerDefinitionResponse::builder).logger(LOG, "deleteSchedulerDefinition").serviceDetails("FleetAppsManagementOperations", "DeleteSchedulerDefinition", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/SchedulerDefinition/DeleteSchedulerDefinition").method(Method.DELETE).requestBuilder(DeleteSchedulerDefinitionRequest::builder).basePath("/20230831").appendPathParam("schedulerDefinitions").appendPathParam(request.getSchedulerDefinitionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSchedulerDefinitionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSchedulerJobResponse> deleteSchedulerJob(DeleteSchedulerJobRequest request, AsyncHandler<DeleteSchedulerJobRequest, DeleteSchedulerJobResponse> handler) {
        Validate.notBlank((String)request.getSchedulerJobId(), (String)"schedulerJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSchedulerJobResponse::builder).logger(LOG, "deleteSchedulerJob").serviceDetails("FleetAppsManagementOperations", "DeleteSchedulerJob", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/SchedulerJob/DeleteSchedulerJob").method(Method.DELETE).requestBuilder(DeleteSchedulerJobRequest::builder).basePath("/20230831").appendPathParam("schedulerJobs").appendPathParam(request.getSchedulerJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSchedulerJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ExportComplianceReportResponse> exportComplianceReport(ExportComplianceReportRequest request, AsyncHandler<ExportComplianceReportRequest, ExportComplianceReportResponse> handler) {
        Objects.requireNonNull(request.getExportComplianceReportDetails(), "exportComplianceReportDetails is required");
        return this.clientCall(request, ExportComplianceReportResponse::builder).logger(LOG, "exportComplianceReport").serviceDetails("FleetAppsManagementOperations", "ExportComplianceReport", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/ComplianceRecord/ExportComplianceReport").method(Method.POST).requestBuilder(ExportComplianceReportRequest::builder).basePath("/20230831").appendPathParam("complianceRecords").appendPathParam("actions").appendPathParam("exportComplianceReport").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(InputStream.class, ExportComplianceReportResponse.Builder::inputStream).handleResponseHeaderString("etag", ExportComplianceReportResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ExportComplianceReportResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", ExportComplianceReportResponse.Builder::contentLength).handleResponseHeaderString("content-type", ExportComplianceReportResponse.Builder::contentType).callAsync(handler);
    }

    @Override
    public Future<GetExecutionResponse> getExecution(GetExecutionRequest request, AsyncHandler<GetExecutionRequest, GetExecutionResponse> handler) {
        Validate.notBlank((String)request.getSchedulerJobId(), (String)"schedulerJobId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobActivityId(), (String)"jobActivityId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResourceId(), (String)"resourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExecutionId(), (String)"executionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExecutionResponse::builder).logger(LOG, "getExecution").serviceDetails("FleetAppsManagementOperations", "GetExecution", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Execution/GetExecution").method(Method.GET).requestBuilder(GetExecutionRequest::builder).basePath("/20230831").appendPathParam("schedulerJobs").appendPathParam(request.getSchedulerJobId()).appendPathParam("jobActivities").appendPathParam(request.getJobActivityId()).appendPathParam("resources").appendPathParam(request.getResourceId()).appendPathParam("executions").appendPathParam(request.getExecutionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Execution.class, GetExecutionResponse.Builder::execution).handleResponseHeaderString("etag", GetExecutionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExecutionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetJobActivityResponse> getJobActivity(GetJobActivityRequest request, AsyncHandler<GetJobActivityRequest, GetJobActivityResponse> handler) {
        Validate.notBlank((String)request.getSchedulerJobId(), (String)"schedulerJobId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobActivityId(), (String)"jobActivityId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetJobActivityResponse::builder).logger(LOG, "getJobActivity").serviceDetails("FleetAppsManagementOperations", "GetJobActivity", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/JobActivity/GetJobActivity").method(Method.GET).requestBuilder(GetJobActivityRequest::builder).basePath("/20230831").appendPathParam("schedulerJobs").appendPathParam(request.getSchedulerJobId()).appendPathParam("jobActivities").appendPathParam(request.getJobActivityId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobActivity.class, GetJobActivityResponse.Builder::jobActivity).handleResponseHeaderString("etag", GetJobActivityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJobActivityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPatchResponse> getPatch(GetPatchRequest request, AsyncHandler<GetPatchRequest, GetPatchResponse> handler) {
        Validate.notBlank((String)request.getPatchId(), (String)"patchId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPatchResponse::builder).logger(LOG, "getPatch").serviceDetails("FleetAppsManagementOperations", "GetPatch", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Patch/GetPatch").method(Method.GET).requestBuilder(GetPatchRequest::builder).basePath("/20230831").appendPathParam("patches").appendPathParam(request.getPatchId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Patch.class, GetPatchResponse.Builder::patch).handleResponseHeaderString("etag", GetPatchResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPatchResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSchedulerDefinitionResponse> getSchedulerDefinition(GetSchedulerDefinitionRequest request, AsyncHandler<GetSchedulerDefinitionRequest, GetSchedulerDefinitionResponse> handler) {
        Validate.notBlank((String)request.getSchedulerDefinitionId(), (String)"schedulerDefinitionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSchedulerDefinitionResponse::builder).logger(LOG, "getSchedulerDefinition").serviceDetails("FleetAppsManagementOperations", "GetSchedulerDefinition", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/SchedulerDefinition/GetSchedulerDefinition").method(Method.GET).requestBuilder(GetSchedulerDefinitionRequest::builder).basePath("/20230831").appendPathParam("schedulerDefinitions").appendPathParam(request.getSchedulerDefinitionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SchedulerDefinition.class, GetSchedulerDefinitionResponse.Builder::schedulerDefinition).handleResponseHeaderString("etag", GetSchedulerDefinitionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSchedulerDefinitionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSchedulerJobResponse> getSchedulerJob(GetSchedulerJobRequest request, AsyncHandler<GetSchedulerJobRequest, GetSchedulerJobResponse> handler) {
        Validate.notBlank((String)request.getSchedulerJobId(), (String)"schedulerJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSchedulerJobResponse::builder).logger(LOG, "getSchedulerJob").serviceDetails("FleetAppsManagementOperations", "GetSchedulerJob", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/SchedulerJob/GetSchedulerJob").method(Method.GET).requestBuilder(GetSchedulerJobRequest::builder).basePath("/20230831").appendPathParam("schedulerJobs").appendPathParam(request.getSchedulerJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SchedulerJob.class, GetSchedulerJobResponse.Builder::schedulerJob).handleResponseHeaderString("etag", GetSchedulerJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSchedulerJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListComplianceRecordsResponse> listComplianceRecords(ListComplianceRecordsRequest request, AsyncHandler<ListComplianceRecordsRequest, ListComplianceRecordsResponse> handler) {
        return this.clientCall(request, ListComplianceRecordsResponse::builder).logger(LOG, "listComplianceRecords").serviceDetails("FleetAppsManagementOperations", "ListComplianceRecords", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/ComplianceRecordCollection/ListComplianceRecords").method(Method.GET).requestBuilder(ListComplianceRecordsRequest::builder).basePath("/20230831").appendPathParam("complianceRecords").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("entityId", (Object)request.getEntityId()).appendQueryParam("productName", (Object)request.getProductName()).appendQueryParam("productStack", (Object)request.getProductStack()).appendQueryParam("targetName", (Object)request.getTargetName()).appendQueryParam("complianceState", (Object)request.getComplianceState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ComplianceRecordCollection.class, ListComplianceRecordsResponse.Builder::complianceRecordCollection).handleResponseHeaderString("opc-request-id", ListComplianceRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListComplianceRecordsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExecutionsResponse> listExecutions(ListExecutionsRequest request, AsyncHandler<ListExecutionsRequest, ListExecutionsResponse> handler) {
        Validate.notBlank((String)request.getSchedulerJobId(), (String)"schedulerJobId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobActivityId(), (String)"jobActivityId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResourceId(), (String)"resourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListExecutionsResponse::builder).logger(LOG, "listExecutions").serviceDetails("FleetAppsManagementOperations", "ListExecutions", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/ExecutionCollection/ListExecutions").method(Method.GET).requestBuilder(ListExecutionsRequest::builder).basePath("/20230831").appendPathParam("schedulerJobs").appendPathParam(request.getSchedulerJobId()).appendPathParam("jobActivities").appendPathParam(request.getJobActivityId()).appendPathParam("resources").appendPathParam(request.getResourceId()).appendPathParam("executions").appendQueryParam("resourceTaskId", (Object)request.getResourceTaskId()).appendQueryParam("stepName", (Object)request.getStepName()).appendQueryParam("targetName", (Object)request.getTargetName()).appendQueryParam("sequence", (Object)request.getSequence()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExecutionCollection.class, ListExecutionsResponse.Builder::executionCollection).handleResponseHeaderString("opc-request-id", ListExecutionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExecutionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPatchesResponse> listPatches(ListPatchesRequest request, AsyncHandler<ListPatchesRequest, ListPatchesResponse> handler) {
        return this.clientCall(request, ListPatchesResponse::builder).logger(LOG, "listPatches").serviceDetails("FleetAppsManagementOperations", "ListPatches", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/PatchCollection/ListPatches").method(Method.GET).requestBuilder(ListPatchesRequest::builder).basePath("/20230831").appendPathParam("patches").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("productId", (Object)request.getProductId()).appendQueryParam("version", (Object)request.getVersion()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendQueryParam("patchTypeId", (Object)request.getPatchTypeId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("timeReleasedGreaterThanOrEqualTo", (Object)request.getTimeReleasedGreaterThanOrEqualTo()).appendQueryParam("timeReleasedLessThan", (Object)request.getTimeReleasedLessThan()).appendQueryParam("shouldCompliancePolicyRulesBeApplied", (Object)request.getShouldCompliancePolicyRulesBeApplied()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PatchCollection.class, ListPatchesResponse.Builder::patchCollection).handleResponseHeaderString("opc-request-id", ListPatchesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPatchesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListResourcesResponse> listResources(ListResourcesRequest request, AsyncHandler<ListResourcesRequest, ListResourcesResponse> handler) {
        Validate.notBlank((String)request.getSchedulerJobId(), (String)"schedulerJobId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobActivityId(), (String)"jobActivityId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListResourcesResponse::builder).logger(LOG, "listResources").serviceDetails("FleetAppsManagementOperations", "ListResources", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/ResourceCollection/ListResources").method(Method.GET).requestBuilder(ListResourcesRequest::builder).basePath("/20230831").appendPathParam("schedulerJobs").appendPathParam(request.getSchedulerJobId()).appendPathParam("jobActivities").appendPathParam(request.getJobActivityId()).appendPathParam("resources").appendQueryParam("resourceTaskId", (Object)request.getResourceTaskId()).appendQueryParam("stepName", (Object)request.getStepName()).appendQueryParam("targetName", (Object)request.getTargetName()).appendQueryParam("sequence", (Object)request.getSequence()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceCollection.class, ListResourcesResponse.Builder::resourceCollection).handleResponseHeaderString("opc-request-id", ListResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResourcesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListScheduledFleetsResponse> listScheduledFleets(ListScheduledFleetsRequest request, AsyncHandler<ListScheduledFleetsRequest, ListScheduledFleetsResponse> handler) {
        Validate.notBlank((String)request.getSchedulerDefinitionId(), (String)"schedulerDefinitionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListScheduledFleetsResponse::builder).logger(LOG, "listScheduledFleets").serviceDetails("FleetAppsManagementOperations", "ListScheduledFleets", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/ScheduledFleetCollection/ListScheduledFleets").method(Method.GET).requestBuilder(ListScheduledFleetsRequest::builder).basePath("/20230831").appendPathParam("schedulerDefinitions").appendPathParam(request.getSchedulerDefinitionId()).appendPathParam("scheduledFleets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledFleetCollection.class, ListScheduledFleetsResponse.Builder::scheduledFleetCollection).handleResponseHeaderString("opc-request-id", ListScheduledFleetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListScheduledFleetsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSchedulerDefinitionsResponse> listSchedulerDefinitions(ListSchedulerDefinitionsRequest request, AsyncHandler<ListSchedulerDefinitionsRequest, ListSchedulerDefinitionsResponse> handler) {
        return this.clientCall(request, ListSchedulerDefinitionsResponse::builder).logger(LOG, "listSchedulerDefinitions").serviceDetails("FleetAppsManagementOperations", "ListSchedulerDefinitions", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/SchedulerDefinitionCollection/ListSchedulerDefinitions").method(Method.GET).requestBuilder(ListSchedulerDefinitionsRequest::builder).basePath("/20230831").appendPathParam("schedulerDefinitions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("product", (Object)request.getProduct()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("maintenanceWindowId", (Object)request.getMaintenanceWindowId()).appendQueryParam("runbookId", (Object)request.getRunbookId()).appendQueryParam("fleetId", (Object)request.getFleetId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SchedulerDefinitionCollection.class, ListSchedulerDefinitionsResponse.Builder::schedulerDefinitionCollection).handleResponseHeaderString("opc-request-id", ListSchedulerDefinitionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSchedulerDefinitionsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListSchedulerDefinitionsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListSchedulerJobsResponse> listSchedulerJobs(ListSchedulerJobsRequest request, AsyncHandler<ListSchedulerJobsRequest, ListSchedulerJobsResponse> handler) {
        return this.clientCall(request, ListSchedulerJobsResponse::builder).logger(LOG, "listSchedulerJobs").serviceDetails("FleetAppsManagementOperations", "ListSchedulerJobs", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/SchedulerJobCollection/ListSchedulerJobs").method(Method.GET).requestBuilder(ListSchedulerJobsRequest::builder).basePath("/20230831").appendPathParam("schedulerJobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("fleetId", (Object)request.getFleetId()).appendQueryParam("timeScheduledGreaterThanOrEqualTo", (Object)request.getTimeScheduledGreaterThanOrEqualTo()).appendQueryParam("timeScheduledLessThan", (Object)request.getTimeScheduledLessThan()).appendQueryParam("isRemediationJobNeeded", (Object)request.getIsRemediationJobNeeded()).appendQueryParam("subState", (Object)request.getSubState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("defintionId", (Object)request.getDefintionId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SchedulerJobCollection.class, ListSchedulerJobsResponse.Builder::schedulerJobCollection).handleResponseHeaderString("opc-request-id", ListSchedulerJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSchedulerJobsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListStepsResponse> listSteps(ListStepsRequest request, AsyncHandler<ListStepsRequest, ListStepsResponse> handler) {
        Validate.notBlank((String)request.getSchedulerJobId(), (String)"schedulerJobId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobActivityId(), (String)"jobActivityId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListStepsResponse::builder).logger(LOG, "listSteps").serviceDetails("FleetAppsManagementOperations", "ListSteps", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/StepCollection/ListSteps").method(Method.GET).requestBuilder(ListStepsRequest::builder).basePath("/20230831").appendPathParam("schedulerJobs").appendPathParam(request.getSchedulerJobId()).appendPathParam("jobActivities").appendPathParam(request.getJobActivityId()).appendPathParam("steps").appendQueryParam("resourceTaskId", (Object)request.getResourceTaskId()).appendQueryParam("stepName", (Object)request.getStepName()).appendQueryParam("targetName", (Object)request.getTargetName()).appendQueryParam("sequence", (Object)request.getSequence()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(StepCollection.class, ListStepsResponse.Builder::stepCollection).handleResponseHeaderString("opc-request-id", ListStepsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListStepsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ManageJobExecutionResponse> manageJobExecution(ManageJobExecutionRequest request, AsyncHandler<ManageJobExecutionRequest, ManageJobExecutionResponse> handler) {
        Objects.requireNonNull(request.getManageJobExecutionDetails(), "manageJobExecutionDetails is required");
        Validate.notBlank((String)request.getSchedulerJobId(), (String)"schedulerJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ManageJobExecutionResponse::builder).logger(LOG, "manageJobExecution").serviceDetails("FleetAppsManagementOperations", "ManageJobExecution", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/SchedulerJob/ManageJobExecution").method(Method.POST).requestBuilder(ManageJobExecutionRequest::builder).basePath("/20230831").appendPathParam("schedulerJobs").appendPathParam(request.getSchedulerJobId()).appendPathParam("actions").appendPathParam("manageJobExecution").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ManageJobExecutionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ManageJobExecutionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SummarizeComplianceRecordCountsResponse> summarizeComplianceRecordCounts(SummarizeComplianceRecordCountsRequest request, AsyncHandler<SummarizeComplianceRecordCountsRequest, SummarizeComplianceRecordCountsResponse> handler) {
        return this.clientCall(request, SummarizeComplianceRecordCountsResponse::builder).logger(LOG, "summarizeComplianceRecordCounts").serviceDetails("FleetAppsManagementOperations", "SummarizeComplianceRecordCounts", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/ComplianceRecordAggregationCollection/SummarizeComplianceRecordCounts").method(Method.GET).requestBuilder(SummarizeComplianceRecordCountsRequest::builder).basePath("/20230831").appendPathParam("complianceRecordCounts").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ComplianceRecordAggregationCollection.class, SummarizeComplianceRecordCountsResponse.Builder::complianceRecordAggregationCollection).handleResponseHeaderString("opc-request-id", SummarizeComplianceRecordCountsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeComplianceRecordCountsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeManagedEntityCountsResponse> summarizeManagedEntityCounts(SummarizeManagedEntityCountsRequest request, AsyncHandler<SummarizeManagedEntityCountsRequest, SummarizeManagedEntityCountsResponse> handler) {
        return this.clientCall(request, SummarizeManagedEntityCountsResponse::builder).logger(LOG, "summarizeManagedEntityCounts").serviceDetails("FleetAppsManagementOperations", "SummarizeManagedEntityCounts", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/ManagedEntityAggregationCollection/SummarizeManagedEntityCounts").method(Method.GET).requestBuilder(SummarizeManagedEntityCountsRequest::builder).basePath("/20230831").appendPathParam("managedEntityCounts").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedEntityAggregationCollection.class, SummarizeManagedEntityCountsResponse.Builder::managedEntityAggregationCollection).handleResponseHeaderString("opc-request-id", SummarizeManagedEntityCountsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeManagedEntityCountsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeSchedulerJobCountsResponse> summarizeSchedulerJobCounts(SummarizeSchedulerJobCountsRequest request, AsyncHandler<SummarizeSchedulerJobCountsRequest, SummarizeSchedulerJobCountsResponse> handler) {
        return this.clientCall(request, SummarizeSchedulerJobCountsResponse::builder).logger(LOG, "summarizeSchedulerJobCounts").serviceDetails("FleetAppsManagementOperations", "SummarizeSchedulerJobCounts", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/SchedulerJobAggregationCollection/SummarizeSchedulerJobCounts").method(Method.GET).requestBuilder(SummarizeSchedulerJobCountsRequest::builder).basePath("/20230831").appendPathParam("schedulerJobCounts").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SchedulerJobAggregationCollection.class, SummarizeSchedulerJobCountsResponse.Builder::schedulerJobAggregationCollection).handleResponseHeaderString("opc-request-id", SummarizeSchedulerJobCountsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeSchedulerJobCountsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdatePatchResponse> updatePatch(UpdatePatchRequest request, AsyncHandler<UpdatePatchRequest, UpdatePatchResponse> handler) {
        Validate.notBlank((String)request.getPatchId(), (String)"patchId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePatchDetails(), "updatePatchDetails is required");
        return this.clientCall(request, UpdatePatchResponse::builder).logger(LOG, "updatePatch").serviceDetails("FleetAppsManagementOperations", "UpdatePatch", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Patch/UpdatePatch").method(Method.PUT).requestBuilder(UpdatePatchRequest::builder).basePath("/20230831").appendPathParam("patches").appendPathParam(request.getPatchId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdatePatchResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdatePatchResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSchedulerDefinitionResponse> updateSchedulerDefinition(UpdateSchedulerDefinitionRequest request, AsyncHandler<UpdateSchedulerDefinitionRequest, UpdateSchedulerDefinitionResponse> handler) {
        Validate.notBlank((String)request.getSchedulerDefinitionId(), (String)"schedulerDefinitionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSchedulerDefinitionDetails(), "updateSchedulerDefinitionDetails is required");
        return this.clientCall(request, UpdateSchedulerDefinitionResponse::builder).logger(LOG, "updateSchedulerDefinition").serviceDetails("FleetAppsManagementOperations", "UpdateSchedulerDefinition", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/SchedulerDefinition/UpdateSchedulerDefinition").method(Method.PUT).requestBuilder(UpdateSchedulerDefinitionRequest::builder).basePath("/20230831").appendPathParam("schedulerDefinitions").appendPathParam(request.getSchedulerDefinitionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateSchedulerDefinitionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateSchedulerDefinitionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSchedulerJobResponse> updateSchedulerJob(UpdateSchedulerJobRequest request, AsyncHandler<UpdateSchedulerJobRequest, UpdateSchedulerJobResponse> handler) {
        Validate.notBlank((String)request.getSchedulerJobId(), (String)"schedulerJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSchedulerJobDetails(), "updateSchedulerJobDetails is required");
        return this.clientCall(request, UpdateSchedulerJobResponse::builder).logger(LOG, "updateSchedulerJob").serviceDetails("FleetAppsManagementOperations", "UpdateSchedulerJob", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/SchedulerJob/UpdateSchedulerJob").method(Method.PUT).requestBuilder(UpdateSchedulerJobRequest::builder).basePath("/20230831").appendPathParam("schedulerJobs").appendPathParam(request.getSchedulerJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SchedulerJob.class, UpdateSchedulerJobResponse.Builder::schedulerJob).handleResponseHeaderString("etag", UpdateSchedulerJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSchedulerJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public FleetAppsManagementOperationsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)FleetAppsManagementOperationsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementOperationsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(FleetAppsManagementOperationsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementOperationsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)FleetAppsManagementOperationsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementOperationsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)FleetAppsManagementOperationsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementOperationsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)FleetAppsManagementOperationsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementOperationsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)FleetAppsManagementOperationsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementOperationsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FleetAppsManagementOperationsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FleetAppsManagementOperationsAsyncClient> {
        private boolean isStreamWarningEnabled = true;

        private Builder(Service service) {
            super(service);
            String packageName = "fleetappsmanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"fleetappsmanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public FleetAppsManagementOperationsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new FleetAppsManagementOperationsAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.isStreamWarningEnabled);
        }
    }
}

