/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementOperations;
import com.oracle.bmc.fleetappsmanagement.model.ComplianceRecordSummary;
import com.oracle.bmc.fleetappsmanagement.model.ExecutionSummary;
import com.oracle.bmc.fleetappsmanagement.model.PatchSummary;
import com.oracle.bmc.fleetappsmanagement.model.ResourceSummary;
import com.oracle.bmc.fleetappsmanagement.model.ScheduledFleetSummary;
import com.oracle.bmc.fleetappsmanagement.model.SchedulerDefinitionSummary;
import com.oracle.bmc.fleetappsmanagement.model.SchedulerJobSummary;
import com.oracle.bmc.fleetappsmanagement.model.StepSummary;
import com.oracle.bmc.fleetappsmanagement.requests.ListComplianceRecordsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListExecutionsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListPatchesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListResourcesRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListScheduledFleetsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListSchedulerDefinitionsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListSchedulerJobsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListStepsRequest;
import com.oracle.bmc.fleetappsmanagement.responses.ListComplianceRecordsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListExecutionsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListPatchesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListResourcesResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListScheduledFleetsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListSchedulerDefinitionsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListSchedulerJobsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListStepsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class FleetAppsManagementOperationsPaginators {
    private final FleetAppsManagementOperations client;

    public FleetAppsManagementOperationsPaginators(FleetAppsManagementOperations client) {
        this.client = client;
    }

    public Iterable<ListComplianceRecordsResponse> listComplianceRecordsResponseIterator(final ListComplianceRecordsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListComplianceRecordsRequest.Builder>(){

            @Override
            public ListComplianceRecordsRequest.Builder get() {
                return ListComplianceRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListComplianceRecordsResponse, String>(){

            @Override
            public String apply(ListComplianceRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListComplianceRecordsRequest.Builder>, ListComplianceRecordsRequest>(){

            @Override
            public ListComplianceRecordsRequest apply(RequestBuilderAndToken<ListComplianceRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListComplianceRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListComplianceRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListComplianceRecordsRequest, ListComplianceRecordsResponse>(){

            @Override
            public ListComplianceRecordsResponse apply(ListComplianceRecordsRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listComplianceRecords(request);
            }
        });
    }

    public Iterable<ComplianceRecordSummary> listComplianceRecordsRecordIterator(final ListComplianceRecordsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListComplianceRecordsRequest.Builder>(){

            @Override
            public ListComplianceRecordsRequest.Builder get() {
                return ListComplianceRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListComplianceRecordsResponse, String>(){

            @Override
            public String apply(ListComplianceRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListComplianceRecordsRequest.Builder>, ListComplianceRecordsRequest>(){

            @Override
            public ListComplianceRecordsRequest apply(RequestBuilderAndToken<ListComplianceRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListComplianceRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListComplianceRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListComplianceRecordsRequest, ListComplianceRecordsResponse>(){

            @Override
            public ListComplianceRecordsResponse apply(ListComplianceRecordsRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listComplianceRecords(request);
            }
        }, (Function)new Function<ListComplianceRecordsResponse, List<ComplianceRecordSummary>>(){

            @Override
            public List<ComplianceRecordSummary> apply(ListComplianceRecordsResponse response) {
                return response.getComplianceRecordCollection().getItems();
            }
        });
    }

    public Iterable<ListExecutionsResponse> listExecutionsResponseIterator(final ListExecutionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListExecutionsRequest.Builder>(){

            @Override
            public ListExecutionsRequest.Builder get() {
                return ListExecutionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExecutionsResponse, String>(){

            @Override
            public String apply(ListExecutionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExecutionsRequest.Builder>, ListExecutionsRequest>(){

            @Override
            public ListExecutionsRequest apply(RequestBuilderAndToken<ListExecutionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListExecutionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExecutionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListExecutionsRequest, ListExecutionsResponse>(){

            @Override
            public ListExecutionsResponse apply(ListExecutionsRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listExecutions(request);
            }
        });
    }

    public Iterable<ExecutionSummary> listExecutionsRecordIterator(final ListExecutionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListExecutionsRequest.Builder>(){

            @Override
            public ListExecutionsRequest.Builder get() {
                return ListExecutionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExecutionsResponse, String>(){

            @Override
            public String apply(ListExecutionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExecutionsRequest.Builder>, ListExecutionsRequest>(){

            @Override
            public ListExecutionsRequest apply(RequestBuilderAndToken<ListExecutionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListExecutionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExecutionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListExecutionsRequest, ListExecutionsResponse>(){

            @Override
            public ListExecutionsResponse apply(ListExecutionsRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listExecutions(request);
            }
        }, (Function)new Function<ListExecutionsResponse, List<ExecutionSummary>>(){

            @Override
            public List<ExecutionSummary> apply(ListExecutionsResponse response) {
                return response.getExecutionCollection().getItems();
            }
        });
    }

    public Iterable<ListPatchesResponse> listPatchesResponseIterator(final ListPatchesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPatchesRequest.Builder>(){

            @Override
            public ListPatchesRequest.Builder get() {
                return ListPatchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPatchesResponse, String>(){

            @Override
            public String apply(ListPatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPatchesRequest.Builder>, ListPatchesRequest>(){

            @Override
            public ListPatchesRequest apply(RequestBuilderAndToken<ListPatchesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPatchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPatchesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPatchesRequest, ListPatchesResponse>(){

            @Override
            public ListPatchesResponse apply(ListPatchesRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listPatches(request);
            }
        });
    }

    public Iterable<PatchSummary> listPatchesRecordIterator(final ListPatchesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPatchesRequest.Builder>(){

            @Override
            public ListPatchesRequest.Builder get() {
                return ListPatchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPatchesResponse, String>(){

            @Override
            public String apply(ListPatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPatchesRequest.Builder>, ListPatchesRequest>(){

            @Override
            public ListPatchesRequest apply(RequestBuilderAndToken<ListPatchesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPatchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPatchesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPatchesRequest, ListPatchesResponse>(){

            @Override
            public ListPatchesResponse apply(ListPatchesRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listPatches(request);
            }
        }, (Function)new Function<ListPatchesResponse, List<PatchSummary>>(){

            @Override
            public List<PatchSummary> apply(ListPatchesResponse response) {
                return response.getPatchCollection().getItems();
            }
        });
    }

    public Iterable<ListResourcesResponse> listResourcesResponseIterator(final ListResourcesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListResourcesRequest.Builder>(){

            @Override
            public ListResourcesRequest.Builder get() {
                return ListResourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourcesResponse, String>(){

            @Override
            public String apply(ListResourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourcesRequest.Builder>, ListResourcesRequest>(){

            @Override
            public ListResourcesRequest apply(RequestBuilderAndToken<ListResourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourcesRequest, ListResourcesResponse>(){

            @Override
            public ListResourcesResponse apply(ListResourcesRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listResources(request);
            }
        });
    }

    public Iterable<ResourceSummary> listResourcesRecordIterator(final ListResourcesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListResourcesRequest.Builder>(){

            @Override
            public ListResourcesRequest.Builder get() {
                return ListResourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourcesResponse, String>(){

            @Override
            public String apply(ListResourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourcesRequest.Builder>, ListResourcesRequest>(){

            @Override
            public ListResourcesRequest apply(RequestBuilderAndToken<ListResourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourcesRequest, ListResourcesResponse>(){

            @Override
            public ListResourcesResponse apply(ListResourcesRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listResources(request);
            }
        }, (Function)new Function<ListResourcesResponse, List<ResourceSummary>>(){

            @Override
            public List<ResourceSummary> apply(ListResourcesResponse response) {
                return response.getResourceCollection().getItems();
            }
        });
    }

    public Iterable<ListScheduledFleetsResponse> listScheduledFleetsResponseIterator(final ListScheduledFleetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListScheduledFleetsRequest.Builder>(){

            @Override
            public ListScheduledFleetsRequest.Builder get() {
                return ListScheduledFleetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListScheduledFleetsResponse, String>(){

            @Override
            public String apply(ListScheduledFleetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListScheduledFleetsRequest.Builder>, ListScheduledFleetsRequest>(){

            @Override
            public ListScheduledFleetsRequest apply(RequestBuilderAndToken<ListScheduledFleetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListScheduledFleetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListScheduledFleetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListScheduledFleetsRequest, ListScheduledFleetsResponse>(){

            @Override
            public ListScheduledFleetsResponse apply(ListScheduledFleetsRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listScheduledFleets(request);
            }
        });
    }

    public Iterable<ScheduledFleetSummary> listScheduledFleetsRecordIterator(final ListScheduledFleetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListScheduledFleetsRequest.Builder>(){

            @Override
            public ListScheduledFleetsRequest.Builder get() {
                return ListScheduledFleetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListScheduledFleetsResponse, String>(){

            @Override
            public String apply(ListScheduledFleetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListScheduledFleetsRequest.Builder>, ListScheduledFleetsRequest>(){

            @Override
            public ListScheduledFleetsRequest apply(RequestBuilderAndToken<ListScheduledFleetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListScheduledFleetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListScheduledFleetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListScheduledFleetsRequest, ListScheduledFleetsResponse>(){

            @Override
            public ListScheduledFleetsResponse apply(ListScheduledFleetsRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listScheduledFleets(request);
            }
        }, (Function)new Function<ListScheduledFleetsResponse, List<ScheduledFleetSummary>>(){

            @Override
            public List<ScheduledFleetSummary> apply(ListScheduledFleetsResponse response) {
                return response.getScheduledFleetCollection().getItems();
            }
        });
    }

    public Iterable<ListSchedulerDefinitionsResponse> listSchedulerDefinitionsResponseIterator(final ListSchedulerDefinitionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSchedulerDefinitionsRequest.Builder>(){

            @Override
            public ListSchedulerDefinitionsRequest.Builder get() {
                return ListSchedulerDefinitionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSchedulerDefinitionsResponse, String>(){

            @Override
            public String apply(ListSchedulerDefinitionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSchedulerDefinitionsRequest.Builder>, ListSchedulerDefinitionsRequest>(){

            @Override
            public ListSchedulerDefinitionsRequest apply(RequestBuilderAndToken<ListSchedulerDefinitionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSchedulerDefinitionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSchedulerDefinitionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSchedulerDefinitionsRequest, ListSchedulerDefinitionsResponse>(){

            @Override
            public ListSchedulerDefinitionsResponse apply(ListSchedulerDefinitionsRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listSchedulerDefinitions(request);
            }
        });
    }

    public Iterable<SchedulerDefinitionSummary> listSchedulerDefinitionsRecordIterator(final ListSchedulerDefinitionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSchedulerDefinitionsRequest.Builder>(){

            @Override
            public ListSchedulerDefinitionsRequest.Builder get() {
                return ListSchedulerDefinitionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSchedulerDefinitionsResponse, String>(){

            @Override
            public String apply(ListSchedulerDefinitionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSchedulerDefinitionsRequest.Builder>, ListSchedulerDefinitionsRequest>(){

            @Override
            public ListSchedulerDefinitionsRequest apply(RequestBuilderAndToken<ListSchedulerDefinitionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSchedulerDefinitionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSchedulerDefinitionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSchedulerDefinitionsRequest, ListSchedulerDefinitionsResponse>(){

            @Override
            public ListSchedulerDefinitionsResponse apply(ListSchedulerDefinitionsRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listSchedulerDefinitions(request);
            }
        }, (Function)new Function<ListSchedulerDefinitionsResponse, List<SchedulerDefinitionSummary>>(){

            @Override
            public List<SchedulerDefinitionSummary> apply(ListSchedulerDefinitionsResponse response) {
                return response.getSchedulerDefinitionCollection().getItems();
            }
        });
    }

    public Iterable<ListSchedulerJobsResponse> listSchedulerJobsResponseIterator(final ListSchedulerJobsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSchedulerJobsRequest.Builder>(){

            @Override
            public ListSchedulerJobsRequest.Builder get() {
                return ListSchedulerJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSchedulerJobsResponse, String>(){

            @Override
            public String apply(ListSchedulerJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSchedulerJobsRequest.Builder>, ListSchedulerJobsRequest>(){

            @Override
            public ListSchedulerJobsRequest apply(RequestBuilderAndToken<ListSchedulerJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSchedulerJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSchedulerJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSchedulerJobsRequest, ListSchedulerJobsResponse>(){

            @Override
            public ListSchedulerJobsResponse apply(ListSchedulerJobsRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listSchedulerJobs(request);
            }
        });
    }

    public Iterable<SchedulerJobSummary> listSchedulerJobsRecordIterator(final ListSchedulerJobsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSchedulerJobsRequest.Builder>(){

            @Override
            public ListSchedulerJobsRequest.Builder get() {
                return ListSchedulerJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSchedulerJobsResponse, String>(){

            @Override
            public String apply(ListSchedulerJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSchedulerJobsRequest.Builder>, ListSchedulerJobsRequest>(){

            @Override
            public ListSchedulerJobsRequest apply(RequestBuilderAndToken<ListSchedulerJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSchedulerJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSchedulerJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSchedulerJobsRequest, ListSchedulerJobsResponse>(){

            @Override
            public ListSchedulerJobsResponse apply(ListSchedulerJobsRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listSchedulerJobs(request);
            }
        }, (Function)new Function<ListSchedulerJobsResponse, List<SchedulerJobSummary>>(){

            @Override
            public List<SchedulerJobSummary> apply(ListSchedulerJobsResponse response) {
                return response.getSchedulerJobCollection().getItems();
            }
        });
    }

    public Iterable<ListStepsResponse> listStepsResponseIterator(final ListStepsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListStepsRequest.Builder>(){

            @Override
            public ListStepsRequest.Builder get() {
                return ListStepsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStepsResponse, String>(){

            @Override
            public String apply(ListStepsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStepsRequest.Builder>, ListStepsRequest>(){

            @Override
            public ListStepsRequest apply(RequestBuilderAndToken<ListStepsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStepsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStepsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStepsRequest, ListStepsResponse>(){

            @Override
            public ListStepsResponse apply(ListStepsRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listSteps(request);
            }
        });
    }

    public Iterable<StepSummary> listStepsRecordIterator(final ListStepsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListStepsRequest.Builder>(){

            @Override
            public ListStepsRequest.Builder get() {
                return ListStepsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStepsResponse, String>(){

            @Override
            public String apply(ListStepsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStepsRequest.Builder>, ListStepsRequest>(){

            @Override
            public ListStepsRequest apply(RequestBuilderAndToken<ListStepsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStepsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStepsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStepsRequest, ListStepsResponse>(){

            @Override
            public ListStepsResponse apply(ListStepsRequest request) {
                return FleetAppsManagementOperationsPaginators.this.client.listSteps(request);
            }
        }, (Function)new Function<ListStepsResponse, List<StepSummary>>(){

            @Override
            public List<StepSummary> apply(ListStepsResponse response) {
                return response.getStepCollection().getItems();
            }
        });
    }
}

