/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementOperations;
import com.oracle.bmc.fleetappsmanagement.model.Patch;
import com.oracle.bmc.fleetappsmanagement.model.SchedulerDefinition;
import com.oracle.bmc.fleetappsmanagement.model.SchedulerJob;
import com.oracle.bmc.fleetappsmanagement.requests.GetPatchRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetSchedulerDefinitionRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetSchedulerJobRequest;
import com.oracle.bmc.fleetappsmanagement.responses.GetPatchResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetSchedulerDefinitionResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetSchedulerJobResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class FleetAppsManagementOperationsWaiters {
    private final ExecutorService executorService;
    private final FleetAppsManagementOperations client;

    public FleetAppsManagementOperationsWaiters(ExecutorService executorService, FleetAppsManagementOperations client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetPatchRequest, GetPatchResponse> forPatch(GetPatchRequest request, Patch.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPatch(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPatchRequest, GetPatchResponse> forPatch(GetPatchRequest request, Patch.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPatch(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPatchRequest, GetPatchResponse> forPatch(GetPatchRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Patch.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPatch(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPatchRequest, GetPatchResponse> forPatch(BmcGenericWaiter waiter, GetPatchRequest request, Patch.LifecycleState ... targetStates) {
        final HashSet<Patch.LifecycleState> targetStatesSet = new HashSet<Patch.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPatchRequest, GetPatchResponse>(){

            @Override
            public GetPatchResponse apply(GetPatchRequest request) {
                return FleetAppsManagementOperationsWaiters.this.client.getPatch(request);
            }
        }, (Predicate)new Predicate<GetPatchResponse>(){

            @Override
            public boolean test(GetPatchResponse response) {
                return targetStatesSet.contains((Object)response.getPatch().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Patch.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSchedulerDefinitionRequest, GetSchedulerDefinitionResponse> forSchedulerDefinition(GetSchedulerDefinitionRequest request, SchedulerDefinition.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSchedulerDefinition(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSchedulerDefinitionRequest, GetSchedulerDefinitionResponse> forSchedulerDefinition(GetSchedulerDefinitionRequest request, SchedulerDefinition.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSchedulerDefinition(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSchedulerDefinitionRequest, GetSchedulerDefinitionResponse> forSchedulerDefinition(GetSchedulerDefinitionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SchedulerDefinition.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSchedulerDefinition(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSchedulerDefinitionRequest, GetSchedulerDefinitionResponse> forSchedulerDefinition(BmcGenericWaiter waiter, GetSchedulerDefinitionRequest request, SchedulerDefinition.LifecycleState ... targetStates) {
        final HashSet<SchedulerDefinition.LifecycleState> targetStatesSet = new HashSet<SchedulerDefinition.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSchedulerDefinitionRequest, GetSchedulerDefinitionResponse>(){

            @Override
            public GetSchedulerDefinitionResponse apply(GetSchedulerDefinitionRequest request) {
                return FleetAppsManagementOperationsWaiters.this.client.getSchedulerDefinition(request);
            }
        }, (Predicate)new Predicate<GetSchedulerDefinitionResponse>(){

            @Override
            public boolean test(GetSchedulerDefinitionResponse response) {
                return targetStatesSet.contains((Object)response.getSchedulerDefinition().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SchedulerDefinition.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSchedulerJobRequest, GetSchedulerJobResponse> forSchedulerJob(GetSchedulerJobRequest request, SchedulerJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSchedulerJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSchedulerJobRequest, GetSchedulerJobResponse> forSchedulerJob(GetSchedulerJobRequest request, SchedulerJob.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSchedulerJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSchedulerJobRequest, GetSchedulerJobResponse> forSchedulerJob(GetSchedulerJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SchedulerJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSchedulerJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSchedulerJobRequest, GetSchedulerJobResponse> forSchedulerJob(BmcGenericWaiter waiter, GetSchedulerJobRequest request, SchedulerJob.LifecycleState ... targetStates) {
        final HashSet<SchedulerJob.LifecycleState> targetStatesSet = new HashSet<SchedulerJob.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSchedulerJobRequest, GetSchedulerJobResponse>(){

            @Override
            public GetSchedulerJobResponse apply(GetSchedulerJobRequest request) {
                return FleetAppsManagementOperationsWaiters.this.client.getSchedulerJob(request);
            }
        }, (Predicate)new Predicate<GetSchedulerJobResponse>(){

            @Override
            public boolean test(GetSchedulerJobResponse response) {
                return targetStatesSet.contains((Object)response.getSchedulerJob().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SchedulerJob.LifecycleState.Deleted)), (Object)request);
    }
}

