/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementRunbooksAsync;
import com.oracle.bmc.fleetappsmanagement.model.Runbook;
import com.oracle.bmc.fleetappsmanagement.model.RunbookCollection;
import com.oracle.bmc.fleetappsmanagement.model.TaskRecord;
import com.oracle.bmc.fleetappsmanagement.model.TaskRecordCollection;
import com.oracle.bmc.fleetappsmanagement.requests.CreateRunbookRequest;
import com.oracle.bmc.fleetappsmanagement.requests.CreateTaskRecordRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeleteRunbookRequest;
import com.oracle.bmc.fleetappsmanagement.requests.DeleteTaskRecordRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetRunbookRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetTaskRecordRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListRunbooksRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListTaskRecordsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.PublishRunbookRequest;
import com.oracle.bmc.fleetappsmanagement.requests.SetDefaultRunbookRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdateRunbookRequest;
import com.oracle.bmc.fleetappsmanagement.requests.UpdateTaskRecordRequest;
import com.oracle.bmc.fleetappsmanagement.responses.CreateRunbookResponse;
import com.oracle.bmc.fleetappsmanagement.responses.CreateTaskRecordResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeleteRunbookResponse;
import com.oracle.bmc.fleetappsmanagement.responses.DeleteTaskRecordResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetRunbookResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetTaskRecordResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListRunbooksResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListTaskRecordsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.PublishRunbookResponse;
import com.oracle.bmc.fleetappsmanagement.responses.SetDefaultRunbookResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdateRunbookResponse;
import com.oracle.bmc.fleetappsmanagement.responses.UpdateTaskRecordResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FleetAppsManagementRunbooksAsyncClient
extends BaseAsyncClient
implements FleetAppsManagementRunbooksAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FLEETAPPSMANAGEMENTRUNBOOKS").serviceEndpointPrefix("").serviceEndpointTemplate("https://fams.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(FleetAppsManagementRunbooksAsyncClient.class);

    FleetAppsManagementRunbooksAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateRunbookResponse> createRunbook(CreateRunbookRequest request, AsyncHandler<CreateRunbookRequest, CreateRunbookResponse> handler) {
        Objects.requireNonNull(request.getCreateRunbookDetails(), "createRunbookDetails is required");
        return this.clientCall(request, CreateRunbookResponse::builder).logger(LOG, "createRunbook").serviceDetails("FleetAppsManagementRunbooks", "CreateRunbook", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Runbook/CreateRunbook").method(Method.POST).requestBuilder(CreateRunbookRequest::builder).basePath("/20230831").appendPathParam("runbooks").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Runbook.class, CreateRunbookResponse.Builder::runbook).handleResponseHeaderString("location", CreateRunbookResponse.Builder::location).handleResponseHeaderString("content-location", CreateRunbookResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateRunbookResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateRunbookResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateRunbookResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateTaskRecordResponse> createTaskRecord(CreateTaskRecordRequest request, AsyncHandler<CreateTaskRecordRequest, CreateTaskRecordResponse> handler) {
        Objects.requireNonNull(request.getCreateTaskRecordDetails(), "createTaskRecordDetails is required");
        return this.clientCall(request, CreateTaskRecordResponse::builder).logger(LOG, "createTaskRecord").serviceDetails("FleetAppsManagementRunbooks", "CreateTaskRecord", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/TaskRecord/CreateTaskRecord").method(Method.POST).requestBuilder(CreateTaskRecordRequest::builder).basePath("/20230831").appendPathParam("taskRecords").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TaskRecord.class, CreateTaskRecordResponse.Builder::taskRecord).handleResponseHeaderString("etag", CreateTaskRecordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTaskRecordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteRunbookResponse> deleteRunbook(DeleteRunbookRequest request, AsyncHandler<DeleteRunbookRequest, DeleteRunbookResponse> handler) {
        Validate.notBlank((String)request.getRunbookId(), (String)"runbookId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRunbookResponse::builder).logger(LOG, "deleteRunbook").serviceDetails("FleetAppsManagementRunbooks", "DeleteRunbook", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Runbook/DeleteRunbook").method(Method.DELETE).requestBuilder(DeleteRunbookRequest::builder).basePath("/20230831").appendPathParam("runbooks").appendPathParam(request.getRunbookId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteRunbookResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRunbookResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteTaskRecordResponse> deleteTaskRecord(DeleteTaskRecordRequest request, AsyncHandler<DeleteTaskRecordRequest, DeleteTaskRecordResponse> handler) {
        Validate.notBlank((String)request.getTaskRecordId(), (String)"taskRecordId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTaskRecordResponse::builder).logger(LOG, "deleteTaskRecord").serviceDetails("FleetAppsManagementRunbooks", "DeleteTaskRecord", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/TaskRecord/DeleteTaskRecord").method(Method.DELETE).requestBuilder(DeleteTaskRecordRequest::builder).basePath("/20230831").appendPathParam("taskRecords").appendPathParam(request.getTaskRecordId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteTaskRecordResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteTaskRecordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRunbookResponse> getRunbook(GetRunbookRequest request, AsyncHandler<GetRunbookRequest, GetRunbookResponse> handler) {
        Validate.notBlank((String)request.getRunbookId(), (String)"runbookId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRunbookResponse::builder).logger(LOG, "getRunbook").serviceDetails("FleetAppsManagementRunbooks", "GetRunbook", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Runbook/GetRunbook").method(Method.GET).requestBuilder(GetRunbookRequest::builder).basePath("/20230831").appendPathParam("runbooks").appendPathParam(request.getRunbookId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Runbook.class, GetRunbookResponse.Builder::runbook).handleResponseHeaderString("etag", GetRunbookResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRunbookResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTaskRecordResponse> getTaskRecord(GetTaskRecordRequest request, AsyncHandler<GetTaskRecordRequest, GetTaskRecordResponse> handler) {
        Validate.notBlank((String)request.getTaskRecordId(), (String)"taskRecordId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTaskRecordResponse::builder).logger(LOG, "getTaskRecord").serviceDetails("FleetAppsManagementRunbooks", "GetTaskRecord", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/TaskRecord/GetTaskRecord").method(Method.GET).requestBuilder(GetTaskRecordRequest::builder).basePath("/20230831").appendPathParam("taskRecords").appendPathParam(request.getTaskRecordId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TaskRecord.class, GetTaskRecordResponse.Builder::taskRecord).handleResponseHeaderString("etag", GetTaskRecordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTaskRecordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListRunbooksResponse> listRunbooks(ListRunbooksRequest request, AsyncHandler<ListRunbooksRequest, ListRunbooksResponse> handler) {
        return this.clientCall(request, ListRunbooksResponse::builder).logger(LOG, "listRunbooks").serviceDetails("FleetAppsManagementRunbooks", "ListRunbooks", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/RunbookCollection/ListRunbooks").method(Method.GET).requestBuilder(ListRunbooksRequest::builder).basePath("/20230831").appendPathParam("runbooks").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendEnumQueryParam("runbookRelevance", (BmcEnum)request.getRunbookRelevance()).appendQueryParam("platform", (Object)request.getPlatform()).appendQueryParam("operation", (Object)request.getOperation()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RunbookCollection.class, ListRunbooksResponse.Builder::runbookCollection).handleResponseHeaderString("opc-request-id", ListRunbooksResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRunbooksResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTaskRecordsResponse> listTaskRecords(ListTaskRecordsRequest request, AsyncHandler<ListTaskRecordsRequest, ListTaskRecordsResponse> handler) {
        return this.clientCall(request, ListTaskRecordsResponse::builder).logger(LOG, "listTaskRecords").serviceDetails("FleetAppsManagementRunbooks", "ListTaskRecords", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/TaskRecordCollection/ListTaskRecords").method(Method.GET).requestBuilder(ListTaskRecordsRequest::builder).basePath("/20230831").appendPathParam("taskRecords").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("platform", (Object)request.getPlatform()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TaskRecordCollection.class, ListTaskRecordsResponse.Builder::taskRecordCollection).handleResponseHeaderString("opc-request-id", ListTaskRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTaskRecordsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<PublishRunbookResponse> publishRunbook(PublishRunbookRequest request, AsyncHandler<PublishRunbookRequest, PublishRunbookResponse> handler) {
        Objects.requireNonNull(request.getPublishRunbookDetails(), "publishRunbookDetails is required");
        return this.clientCall(request, PublishRunbookResponse::builder).logger(LOG, "publishRunbook").serviceDetails("FleetAppsManagementRunbooks", "PublishRunbook", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Runbook/PublishRunbook").method(Method.POST).requestBuilder(PublishRunbookRequest::builder).basePath("/20230831").appendPathParam("runbooks").appendPathParam("actions").appendPathParam("publishRunbook").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", PublishRunbookResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", PublishRunbookResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SetDefaultRunbookResponse> setDefaultRunbook(SetDefaultRunbookRequest request, AsyncHandler<SetDefaultRunbookRequest, SetDefaultRunbookResponse> handler) {
        Objects.requireNonNull(request.getSetDefaultRunbookDetails(), "setDefaultRunbookDetails is required");
        return this.clientCall(request, SetDefaultRunbookResponse::builder).logger(LOG, "setDefaultRunbook").serviceDetails("FleetAppsManagementRunbooks", "SetDefaultRunbook", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Runbook/SetDefaultRunbook").method(Method.POST).requestBuilder(SetDefaultRunbookRequest::builder).basePath("/20230831").appendPathParam("runbooks").appendPathParam("actions").appendPathParam("setDefaultRunbook").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Runbook.class, SetDefaultRunbookResponse.Builder::runbook).handleResponseHeaderString("etag", SetDefaultRunbookResponse.Builder::etag).handleResponseHeaderString("opc-request-id", SetDefaultRunbookResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateRunbookResponse> updateRunbook(UpdateRunbookRequest request, AsyncHandler<UpdateRunbookRequest, UpdateRunbookResponse> handler) {
        Validate.notBlank((String)request.getRunbookId(), (String)"runbookId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRunbookDetails(), "updateRunbookDetails is required");
        return this.clientCall(request, UpdateRunbookResponse::builder).logger(LOG, "updateRunbook").serviceDetails("FleetAppsManagementRunbooks", "UpdateRunbook", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/Runbook/UpdateRunbook").method(Method.PUT).requestBuilder(UpdateRunbookRequest::builder).basePath("/20230831").appendPathParam("runbooks").appendPathParam(request.getRunbookId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateRunbookResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateRunbookResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateTaskRecordResponse> updateTaskRecord(UpdateTaskRecordRequest request, AsyncHandler<UpdateTaskRecordRequest, UpdateTaskRecordResponse> handler) {
        Validate.notBlank((String)request.getTaskRecordId(), (String)"taskRecordId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTaskRecordDetails(), "updateTaskRecordDetails is required");
        return this.clientCall(request, UpdateTaskRecordResponse::builder).logger(LOG, "updateTaskRecord").serviceDetails("FleetAppsManagementRunbooks", "UpdateTaskRecord", "https://docs.oracle.com/iaas/api/#/en/fleet-management/20230831/TaskRecord/UpdateTaskRecord").method(Method.PUT).requestBuilder(UpdateTaskRecordRequest::builder).basePath("/20230831").appendPathParam("taskRecords").appendPathParam(request.getTaskRecordId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateTaskRecordResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateTaskRecordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public FleetAppsManagementRunbooksAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)FleetAppsManagementRunbooksAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementRunbooksAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(FleetAppsManagementRunbooksAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementRunbooksAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)FleetAppsManagementRunbooksAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementRunbooksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)FleetAppsManagementRunbooksAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementRunbooksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)FleetAppsManagementRunbooksAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementRunbooksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)FleetAppsManagementRunbooksAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public FleetAppsManagementRunbooksAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FleetAppsManagementRunbooksAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FleetAppsManagementRunbooksAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "fleetappsmanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"fleetappsmanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public FleetAppsManagementRunbooksAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new FleetAppsManagementRunbooksAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

