/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementRunbooks;
import com.oracle.bmc.fleetappsmanagement.model.RunbookSummary;
import com.oracle.bmc.fleetappsmanagement.model.TaskRecordSummary;
import com.oracle.bmc.fleetappsmanagement.requests.ListRunbooksRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListTaskRecordsRequest;
import com.oracle.bmc.fleetappsmanagement.responses.ListRunbooksResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListTaskRecordsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class FleetAppsManagementRunbooksPaginators {
    private final FleetAppsManagementRunbooks client;

    public FleetAppsManagementRunbooksPaginators(FleetAppsManagementRunbooks client) {
        this.client = client;
    }

    public Iterable<ListRunbooksResponse> listRunbooksResponseIterator(final ListRunbooksRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRunbooksRequest.Builder>(){

            @Override
            public ListRunbooksRequest.Builder get() {
                return ListRunbooksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRunbooksResponse, String>(){

            @Override
            public String apply(ListRunbooksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRunbooksRequest.Builder>, ListRunbooksRequest>(){

            @Override
            public ListRunbooksRequest apply(RequestBuilderAndToken<ListRunbooksRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRunbooksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRunbooksRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRunbooksRequest, ListRunbooksResponse>(){

            @Override
            public ListRunbooksResponse apply(ListRunbooksRequest request) {
                return FleetAppsManagementRunbooksPaginators.this.client.listRunbooks(request);
            }
        });
    }

    public Iterable<RunbookSummary> listRunbooksRecordIterator(final ListRunbooksRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRunbooksRequest.Builder>(){

            @Override
            public ListRunbooksRequest.Builder get() {
                return ListRunbooksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRunbooksResponse, String>(){

            @Override
            public String apply(ListRunbooksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRunbooksRequest.Builder>, ListRunbooksRequest>(){

            @Override
            public ListRunbooksRequest apply(RequestBuilderAndToken<ListRunbooksRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRunbooksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRunbooksRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRunbooksRequest, ListRunbooksResponse>(){

            @Override
            public ListRunbooksResponse apply(ListRunbooksRequest request) {
                return FleetAppsManagementRunbooksPaginators.this.client.listRunbooks(request);
            }
        }, (Function)new Function<ListRunbooksResponse, List<RunbookSummary>>(){

            @Override
            public List<RunbookSummary> apply(ListRunbooksResponse response) {
                return response.getRunbookCollection().getItems();
            }
        });
    }

    public Iterable<ListTaskRecordsResponse> listTaskRecordsResponseIterator(final ListTaskRecordsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTaskRecordsRequest.Builder>(){

            @Override
            public ListTaskRecordsRequest.Builder get() {
                return ListTaskRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTaskRecordsResponse, String>(){

            @Override
            public String apply(ListTaskRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTaskRecordsRequest.Builder>, ListTaskRecordsRequest>(){

            @Override
            public ListTaskRecordsRequest apply(RequestBuilderAndToken<ListTaskRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTaskRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTaskRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTaskRecordsRequest, ListTaskRecordsResponse>(){

            @Override
            public ListTaskRecordsResponse apply(ListTaskRecordsRequest request) {
                return FleetAppsManagementRunbooksPaginators.this.client.listTaskRecords(request);
            }
        });
    }

    public Iterable<TaskRecordSummary> listTaskRecordsRecordIterator(final ListTaskRecordsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTaskRecordsRequest.Builder>(){

            @Override
            public ListTaskRecordsRequest.Builder get() {
                return ListTaskRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTaskRecordsResponse, String>(){

            @Override
            public String apply(ListTaskRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTaskRecordsRequest.Builder>, ListTaskRecordsRequest>(){

            @Override
            public ListTaskRecordsRequest apply(RequestBuilderAndToken<ListTaskRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTaskRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTaskRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTaskRecordsRequest, ListTaskRecordsResponse>(){

            @Override
            public ListTaskRecordsResponse apply(ListTaskRecordsRequest request) {
                return FleetAppsManagementRunbooksPaginators.this.client.listTaskRecords(request);
            }
        }, (Function)new Function<ListTaskRecordsResponse, List<TaskRecordSummary>>(){

            @Override
            public List<TaskRecordSummary> apply(ListTaskRecordsResponse response) {
                return response.getTaskRecordCollection().getItems();
            }
        });
    }
}

