/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementRunbooks;
import com.oracle.bmc.fleetappsmanagement.model.Runbook;
import com.oracle.bmc.fleetappsmanagement.model.TaskRecord;
import com.oracle.bmc.fleetappsmanagement.requests.GetRunbookRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetTaskRecordRequest;
import com.oracle.bmc.fleetappsmanagement.responses.GetRunbookResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetTaskRecordResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class FleetAppsManagementRunbooksWaiters {
    private final ExecutorService executorService;
    private final FleetAppsManagementRunbooks client;

    public FleetAppsManagementRunbooksWaiters(ExecutorService executorService, FleetAppsManagementRunbooks client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetRunbookRequest, GetRunbookResponse> forRunbook(GetRunbookRequest request, Runbook.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRunbook(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRunbookRequest, GetRunbookResponse> forRunbook(GetRunbookRequest request, Runbook.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRunbook(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRunbookRequest, GetRunbookResponse> forRunbook(GetRunbookRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Runbook.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRunbook(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRunbookRequest, GetRunbookResponse> forRunbook(BmcGenericWaiter waiter, GetRunbookRequest request, Runbook.LifecycleState ... targetStates) {
        final HashSet<Runbook.LifecycleState> targetStatesSet = new HashSet<Runbook.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetRunbookRequest, GetRunbookResponse>(){

            @Override
            public GetRunbookResponse apply(GetRunbookRequest request) {
                return FleetAppsManagementRunbooksWaiters.this.client.getRunbook(request);
            }
        }, (Predicate)new Predicate<GetRunbookResponse>(){

            @Override
            public boolean test(GetRunbookResponse response) {
                return targetStatesSet.contains((Object)response.getRunbook().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Runbook.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTaskRecordRequest, GetTaskRecordResponse> forTaskRecord(GetTaskRecordRequest request, TaskRecord.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTaskRecord(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTaskRecordRequest, GetTaskRecordResponse> forTaskRecord(GetTaskRecordRequest request, TaskRecord.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTaskRecord(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTaskRecordRequest, GetTaskRecordResponse> forTaskRecord(GetTaskRecordRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TaskRecord.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTaskRecord(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTaskRecordRequest, GetTaskRecordResponse> forTaskRecord(BmcGenericWaiter waiter, GetTaskRecordRequest request, TaskRecord.LifecycleState ... targetStates) {
        final HashSet<TaskRecord.LifecycleState> targetStatesSet = new HashSet<TaskRecord.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTaskRecordRequest, GetTaskRecordResponse>(){

            @Override
            public GetTaskRecordResponse apply(GetTaskRecordRequest request) {
                return FleetAppsManagementRunbooksWaiters.this.client.getTaskRecord(request);
            }
        }, (Predicate)new Predicate<GetTaskRecordResponse>(){

            @Override
            public boolean test(GetTaskRecordResponse response) {
                return targetStatesSet.contains((Object)response.getTaskRecord().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TaskRecord.LifecycleState.Deleted)), (Object)request);
    }
}

