/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement;

import com.oracle.bmc.fleetappsmanagement.FleetAppsManagement;
import com.oracle.bmc.fleetappsmanagement.model.Fleet;
import com.oracle.bmc.fleetappsmanagement.model.FleetCredential;
import com.oracle.bmc.fleetappsmanagement.model.FleetProperty;
import com.oracle.bmc.fleetappsmanagement.model.FleetResource;
import com.oracle.bmc.fleetappsmanagement.requests.GetFleetCredentialRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetFleetPropertyRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetFleetRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetFleetResourceRequest;
import com.oracle.bmc.fleetappsmanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.fleetappsmanagement.responses.GetFleetCredentialResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetFleetPropertyResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetFleetResourceResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetFleetResponse;
import com.oracle.bmc.fleetappsmanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class FleetAppsManagementWaiters {
    private final ExecutorService executorService;
    private final FleetAppsManagement client;

    public FleetAppsManagementWaiters(ExecutorService executorService, FleetAppsManagement client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetFleetRequest, GetFleetResponse> forFleet(GetFleetRequest request, Fleet.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFleet(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFleetRequest, GetFleetResponse> forFleet(GetFleetRequest request, Fleet.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFleet(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFleetRequest, GetFleetResponse> forFleet(GetFleetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Fleet.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forFleet(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFleetRequest, GetFleetResponse> forFleet(BmcGenericWaiter waiter, GetFleetRequest request, Fleet.LifecycleState ... targetStates) {
        final HashSet<Fleet.LifecycleState> targetStatesSet = new HashSet<Fleet.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFleetRequest, GetFleetResponse>(){

            @Override
            public GetFleetResponse apply(GetFleetRequest request) {
                return FleetAppsManagementWaiters.this.client.getFleet(request);
            }
        }, (Predicate)new Predicate<GetFleetResponse>(){

            @Override
            public boolean test(GetFleetResponse response) {
                return targetStatesSet.contains((Object)response.getFleet().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Fleet.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetFleetCredentialRequest, GetFleetCredentialResponse> forFleetCredential(GetFleetCredentialRequest request, FleetCredential.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFleetCredential(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFleetCredentialRequest, GetFleetCredentialResponse> forFleetCredential(GetFleetCredentialRequest request, FleetCredential.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFleetCredential(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFleetCredentialRequest, GetFleetCredentialResponse> forFleetCredential(GetFleetCredentialRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, FleetCredential.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forFleetCredential(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFleetCredentialRequest, GetFleetCredentialResponse> forFleetCredential(BmcGenericWaiter waiter, GetFleetCredentialRequest request, FleetCredential.LifecycleState ... targetStates) {
        final HashSet<FleetCredential.LifecycleState> targetStatesSet = new HashSet<FleetCredential.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFleetCredentialRequest, GetFleetCredentialResponse>(){

            @Override
            public GetFleetCredentialResponse apply(GetFleetCredentialRequest request) {
                return FleetAppsManagementWaiters.this.client.getFleetCredential(request);
            }
        }, (Predicate)new Predicate<GetFleetCredentialResponse>(){

            @Override
            public boolean test(GetFleetCredentialResponse response) {
                return targetStatesSet.contains((Object)response.getFleetCredential().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)FleetCredential.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetFleetPropertyRequest, GetFleetPropertyResponse> forFleetProperty(GetFleetPropertyRequest request, FleetProperty.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFleetProperty(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFleetPropertyRequest, GetFleetPropertyResponse> forFleetProperty(GetFleetPropertyRequest request, FleetProperty.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFleetProperty(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFleetPropertyRequest, GetFleetPropertyResponse> forFleetProperty(GetFleetPropertyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, FleetProperty.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forFleetProperty(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFleetPropertyRequest, GetFleetPropertyResponse> forFleetProperty(BmcGenericWaiter waiter, GetFleetPropertyRequest request, FleetProperty.LifecycleState ... targetStates) {
        final HashSet<FleetProperty.LifecycleState> targetStatesSet = new HashSet<FleetProperty.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFleetPropertyRequest, GetFleetPropertyResponse>(){

            @Override
            public GetFleetPropertyResponse apply(GetFleetPropertyRequest request) {
                return FleetAppsManagementWaiters.this.client.getFleetProperty(request);
            }
        }, (Predicate)new Predicate<GetFleetPropertyResponse>(){

            @Override
            public boolean test(GetFleetPropertyResponse response) {
                return targetStatesSet.contains((Object)response.getFleetProperty().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)FleetProperty.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetFleetResourceRequest, GetFleetResourceResponse> forFleetResource(GetFleetResourceRequest request, FleetResource.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFleetResource(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFleetResourceRequest, GetFleetResourceResponse> forFleetResource(GetFleetResourceRequest request, FleetResource.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFleetResource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFleetResourceRequest, GetFleetResourceResponse> forFleetResource(GetFleetResourceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, FleetResource.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forFleetResource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFleetResourceRequest, GetFleetResourceResponse> forFleetResource(BmcGenericWaiter waiter, GetFleetResourceRequest request, FleetResource.LifecycleState ... targetStates) {
        final HashSet<FleetResource.LifecycleState> targetStatesSet = new HashSet<FleetResource.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFleetResourceRequest, GetFleetResourceResponse>(){

            @Override
            public GetFleetResourceResponse apply(GetFleetResourceRequest request) {
                return FleetAppsManagementWaiters.this.client.getFleetResource(request);
            }
        }, (Predicate)new Predicate<GetFleetResourceResponse>(){

            @Override
            public boolean test(GetFleetResourceResponse response) {
                return targetStatesSet.contains((Object)response.getFleetResource().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)FleetResource.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return FleetAppsManagementWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

