/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.LifeCycleActionGroupType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ActionGroup
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="type")
    private final LifeCycleActionGroupType type;
    @JsonProperty(value="applicationType")
    private final String applicationType;
    @JsonProperty(value="product")
    private final String product;
    @JsonProperty(value="lifecycleOperation")
    private final String lifecycleOperation;
    @JsonProperty(value="runbookId")
    private final String runbookId;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="subjects")
    private final List<String> subjects;

    @Deprecated
    @ConstructorProperties(value={"resourceId", "type", "applicationType", "product", "lifecycleOperation", "runbookId", "targetId", "subjects"})
    public ActionGroup(String resourceId, LifeCycleActionGroupType type, String applicationType, String product, String lifecycleOperation, String runbookId, String targetId, List<String> subjects) {
        this.resourceId = resourceId;
        this.type = type;
        this.applicationType = applicationType;
        this.product = product;
        this.lifecycleOperation = lifecycleOperation;
        this.runbookId = runbookId;
        this.targetId = targetId;
        this.subjects = subjects;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public LifeCycleActionGroupType getType() {
        return this.type;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public String getProduct() {
        return this.product;
    }

    public String getLifecycleOperation() {
        return this.lifecycleOperation;
    }

    public String getRunbookId() {
        return this.runbookId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ActionGroup(");
        sb.append("super=").append(super.toString());
        sb.append("resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", applicationType=").append(String.valueOf(this.applicationType));
        sb.append(", product=").append(String.valueOf(this.product));
        sb.append(", lifecycleOperation=").append(String.valueOf(this.lifecycleOperation));
        sb.append(", runbookId=").append(String.valueOf(this.runbookId));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", subjects=").append(String.valueOf(this.subjects));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionGroup)) {
            return false;
        }
        ActionGroup other = (ActionGroup)((Object)o);
        return Objects.equals(this.resourceId, other.resourceId) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.applicationType, other.applicationType) && Objects.equals(this.product, other.product) && Objects.equals(this.lifecycleOperation, other.lifecycleOperation) && Objects.equals(this.runbookId, other.runbookId) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.subjects, other.subjects) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.applicationType == null ? 43 : this.applicationType.hashCode());
        result = result * 59 + (this.product == null ? 43 : this.product.hashCode());
        result = result * 59 + (this.lifecycleOperation == null ? 43 : this.lifecycleOperation.hashCode());
        result = result * 59 + (this.runbookId == null ? 43 : this.runbookId.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.subjects == null ? 43 : this.subjects.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="type")
        private LifeCycleActionGroupType type;
        @JsonProperty(value="applicationType")
        private String applicationType;
        @JsonProperty(value="product")
        private String product;
        @JsonProperty(value="lifecycleOperation")
        private String lifecycleOperation;
        @JsonProperty(value="runbookId")
        private String runbookId;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="subjects")
        private List<String> subjects;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder type(LifeCycleActionGroupType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            this.__explicitlySet__.add("applicationType");
            return this;
        }

        public Builder product(String product) {
            this.product = product;
            this.__explicitlySet__.add("product");
            return this;
        }

        public Builder lifecycleOperation(String lifecycleOperation) {
            this.lifecycleOperation = lifecycleOperation;
            this.__explicitlySet__.add("lifecycleOperation");
            return this;
        }

        public Builder runbookId(String runbookId) {
            this.runbookId = runbookId;
            this.__explicitlySet__.add("runbookId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder subjects(List<String> subjects) {
            this.subjects = subjects;
            this.__explicitlySet__.add("subjects");
            return this;
        }

        public ActionGroup build() {
            ActionGroup model = new ActionGroup(this.resourceId, this.type, this.applicationType, this.product, this.lifecycleOperation, this.runbookId, this.targetId, this.subjects);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ActionGroup model) {
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("applicationType")) {
                this.applicationType(model.getApplicationType());
            }
            if (model.wasPropertyExplicitlySet("product")) {
                this.product(model.getProduct());
            }
            if (model.wasPropertyExplicitlySet("lifecycleOperation")) {
                this.lifecycleOperation(model.getLifecycleOperation());
            }
            if (model.wasPropertyExplicitlySet("runbookId")) {
                this.runbookId(model.getRunbookId());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("subjects")) {
                this.subjects(model.getSubjects());
            }
            return this;
        }
    }
}

