/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AssociatedFleetPropertyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="fleetPropertyType")
    private final FleetPropertyType fleetPropertyType;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="isRequired")
    private final Boolean isRequired;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "displayName", "fleetPropertyType", "value", "isRequired"})
    public AssociatedFleetPropertyDetails(String compartmentId, String displayName, FleetPropertyType fleetPropertyType, String value, Boolean isRequired) {
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.fleetPropertyType = fleetPropertyType;
        this.value = value;
        this.isRequired = isRequired;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public FleetPropertyType getFleetPropertyType() {
        return this.fleetPropertyType;
    }

    public String getValue() {
        return this.value;
    }

    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AssociatedFleetPropertyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", fleetPropertyType=").append(String.valueOf((Object)this.fleetPropertyType));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", isRequired=").append(String.valueOf(this.isRequired));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssociatedFleetPropertyDetails)) {
            return false;
        }
        AssociatedFleetPropertyDetails other = (AssociatedFleetPropertyDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.fleetPropertyType, (Object)other.fleetPropertyType) && Objects.equals(this.value, other.value) && Objects.equals(this.isRequired, other.isRequired) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.fleetPropertyType == null ? 43 : this.fleetPropertyType.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.isRequired == null ? 43 : this.isRequired.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum FleetPropertyType implements BmcEnum
    {
        String("STRING"),
        Number("NUMBER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FleetPropertyType> map;

        private FleetPropertyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FleetPropertyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FleetPropertyType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FleetPropertyType.class);
            map = new HashMap<String, FleetPropertyType>();
            for (FleetPropertyType v : FleetPropertyType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="fleetPropertyType")
        private FleetPropertyType fleetPropertyType;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="isRequired")
        private Boolean isRequired;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder fleetPropertyType(FleetPropertyType fleetPropertyType) {
            this.fleetPropertyType = fleetPropertyType;
            this.__explicitlySet__.add("fleetPropertyType");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.__explicitlySet__.add("isRequired");
            return this;
        }

        public AssociatedFleetPropertyDetails build() {
            AssociatedFleetPropertyDetails model = new AssociatedFleetPropertyDetails(this.compartmentId, this.displayName, this.fleetPropertyType, this.value, this.isRequired);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AssociatedFleetPropertyDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("fleetPropertyType")) {
                this.fleetPropertyType(model.getFleetPropertyType());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("isRequired")) {
                this.isRequired(model.getIsRequired());
            }
            return this;
        }
    }
}

