/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AssociatedFleetResourceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="fleetResourceType")
    private final String fleetResourceType;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="tenancyId")
    private final String tenancyId;

    @Deprecated
    @ConstructorProperties(value={"resourceId", "fleetResourceType", "compartmentId", "tenancyId"})
    public AssociatedFleetResourceDetails(String resourceId, String fleetResourceType, String compartmentId, String tenancyId) {
        this.resourceId = resourceId;
        this.fleetResourceType = fleetResourceType;
        this.compartmentId = compartmentId;
        this.tenancyId = tenancyId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getFleetResourceType() {
        return this.fleetResourceType;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AssociatedFleetResourceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", fleetResourceType=").append(String.valueOf(this.fleetResourceType));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssociatedFleetResourceDetails)) {
            return false;
        }
        AssociatedFleetResourceDetails other = (AssociatedFleetResourceDetails)((Object)o);
        return Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.fleetResourceType, other.fleetResourceType) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.tenancyId, other.tenancyId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.fleetResourceType == null ? 43 : this.fleetResourceType.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="fleetResourceType")
        private String fleetResourceType;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder fleetResourceType(String fleetResourceType) {
            this.fleetResourceType = fleetResourceType;
            this.__explicitlySet__.add("fleetResourceType");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public AssociatedFleetResourceDetails build() {
            AssociatedFleetResourceDetails model = new AssociatedFleetResourceDetails(this.resourceId, this.fleetResourceType, this.compartmentId, this.tenancyId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AssociatedFleetResourceDetails model) {
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("fleetResourceType")) {
                this.fleetResourceType(model.getFleetResourceType());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("tenancyId")) {
                this.tenancyId(model.getTenancyId());
            }
            return this;
        }
    }
}

