/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ComplianceDetailResource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="compartment")
    private final String compartment;
    @JsonProperty(value="resourceRegion")
    private final String resourceRegion;

    @Deprecated
    @ConstructorProperties(value={"resourceId", "resourceName", "compartmentId", "compartment", "resourceRegion"})
    public ComplianceDetailResource(String resourceId, String resourceName, String compartmentId, String compartment, String resourceRegion) {
        this.resourceId = resourceId;
        this.resourceName = resourceName;
        this.compartmentId = compartmentId;
        this.compartment = compartment;
        this.resourceRegion = resourceRegion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCompartment() {
        return this.compartment;
    }

    public String getResourceRegion() {
        return this.resourceRegion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ComplianceDetailResource(");
        sb.append("super=").append(super.toString());
        sb.append("resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", compartment=").append(String.valueOf(this.compartment));
        sb.append(", resourceRegion=").append(String.valueOf(this.resourceRegion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComplianceDetailResource)) {
            return false;
        }
        ComplianceDetailResource other = (ComplianceDetailResource)((Object)o);
        return Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.compartment, other.compartment) && Objects.equals(this.resourceRegion, other.resourceRegion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.compartment == null ? 43 : this.compartment.hashCode());
        result = result * 59 + (this.resourceRegion == null ? 43 : this.resourceRegion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="compartment")
        private String compartment;
        @JsonProperty(value="resourceRegion")
        private String resourceRegion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder compartment(String compartment) {
            this.compartment = compartment;
            this.__explicitlySet__.add("compartment");
            return this;
        }

        public Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            this.__explicitlySet__.add("resourceRegion");
            return this;
        }

        public ComplianceDetailResource build() {
            ComplianceDetailResource model = new ComplianceDetailResource(this.resourceId, this.resourceName, this.compartmentId, this.compartment, this.resourceRegion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ComplianceDetailResource model) {
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("compartment")) {
                this.compartment(model.getCompartment());
            }
            if (model.wasPropertyExplicitlySet("resourceRegion")) {
                this.resourceRegion(model.getResourceRegion());
            }
            return this;
        }
    }
}

