/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.ComplianceDetailProduct;
import com.oracle.bmc.fleetappsmanagement.model.PatchSeverity;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CompliancePatchDetail
extends ExplicitlySetBmcModel {
    @JsonProperty(value="patchId")
    private final String patchId;
    @JsonProperty(value="patchName")
    private final String patchName;
    @JsonProperty(value="patchDescription")
    private final String patchDescription;
    @JsonProperty(value="timeReleased")
    private final Date timeReleased;
    @JsonProperty(value="patchType")
    private final String patchType;
    @JsonProperty(value="severity")
    private final PatchSeverity severity;
    @JsonProperty(value="product")
    private final ComplianceDetailProduct product;

    @Deprecated
    @ConstructorProperties(value={"patchId", "patchName", "patchDescription", "timeReleased", "patchType", "severity", "product"})
    public CompliancePatchDetail(String patchId, String patchName, String patchDescription, Date timeReleased, String patchType, PatchSeverity severity, ComplianceDetailProduct product) {
        this.patchId = patchId;
        this.patchName = patchName;
        this.patchDescription = patchDescription;
        this.timeReleased = timeReleased;
        this.patchType = patchType;
        this.severity = severity;
        this.product = product;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPatchId() {
        return this.patchId;
    }

    public String getPatchName() {
        return this.patchName;
    }

    public String getPatchDescription() {
        return this.patchDescription;
    }

    public Date getTimeReleased() {
        return this.timeReleased;
    }

    public String getPatchType() {
        return this.patchType;
    }

    public PatchSeverity getSeverity() {
        return this.severity;
    }

    public ComplianceDetailProduct getProduct() {
        return this.product;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CompliancePatchDetail(");
        sb.append("super=").append(super.toString());
        sb.append("patchId=").append(String.valueOf(this.patchId));
        sb.append(", patchName=").append(String.valueOf(this.patchName));
        sb.append(", patchDescription=").append(String.valueOf(this.patchDescription));
        sb.append(", timeReleased=").append(String.valueOf(this.timeReleased));
        sb.append(", patchType=").append(String.valueOf(this.patchType));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", product=").append(String.valueOf((Object)this.product));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompliancePatchDetail)) {
            return false;
        }
        CompliancePatchDetail other = (CompliancePatchDetail)((Object)o);
        return Objects.equals(this.patchId, other.patchId) && Objects.equals(this.patchName, other.patchName) && Objects.equals(this.patchDescription, other.patchDescription) && Objects.equals(this.timeReleased, other.timeReleased) && Objects.equals(this.patchType, other.patchType) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals((Object)this.product, (Object)other.product) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.patchId == null ? 43 : this.patchId.hashCode());
        result = result * 59 + (this.patchName == null ? 43 : this.patchName.hashCode());
        result = result * 59 + (this.patchDescription == null ? 43 : this.patchDescription.hashCode());
        result = result * 59 + (this.timeReleased == null ? 43 : this.timeReleased.hashCode());
        result = result * 59 + (this.patchType == null ? 43 : this.patchType.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.product == null ? 43 : this.product.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="patchId")
        private String patchId;
        @JsonProperty(value="patchName")
        private String patchName;
        @JsonProperty(value="patchDescription")
        private String patchDescription;
        @JsonProperty(value="timeReleased")
        private Date timeReleased;
        @JsonProperty(value="patchType")
        private String patchType;
        @JsonProperty(value="severity")
        private PatchSeverity severity;
        @JsonProperty(value="product")
        private ComplianceDetailProduct product;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            this.__explicitlySet__.add("patchId");
            return this;
        }

        public Builder patchName(String patchName) {
            this.patchName = patchName;
            this.__explicitlySet__.add("patchName");
            return this;
        }

        public Builder patchDescription(String patchDescription) {
            this.patchDescription = patchDescription;
            this.__explicitlySet__.add("patchDescription");
            return this;
        }

        public Builder timeReleased(Date timeReleased) {
            this.timeReleased = timeReleased;
            this.__explicitlySet__.add("timeReleased");
            return this;
        }

        public Builder patchType(String patchType) {
            this.patchType = patchType;
            this.__explicitlySet__.add("patchType");
            return this;
        }

        public Builder severity(PatchSeverity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder product(ComplianceDetailProduct product) {
            this.product = product;
            this.__explicitlySet__.add("product");
            return this;
        }

        public CompliancePatchDetail build() {
            CompliancePatchDetail model = new CompliancePatchDetail(this.patchId, this.patchName, this.patchDescription, this.timeReleased, this.patchType, this.severity, this.product);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CompliancePatchDetail model) {
            if (model.wasPropertyExplicitlySet("patchId")) {
                this.patchId(model.getPatchId());
            }
            if (model.wasPropertyExplicitlySet("patchName")) {
                this.patchName(model.getPatchName());
            }
            if (model.wasPropertyExplicitlySet("patchDescription")) {
                this.patchDescription(model.getPatchDescription());
            }
            if (model.wasPropertyExplicitlySet("timeReleased")) {
                this.timeReleased(model.getTimeReleased());
            }
            if (model.wasPropertyExplicitlySet("patchType")) {
                this.patchType(model.getPatchType());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("product")) {
                this.product(model.getProduct());
            }
            return this;
        }
    }
}

