/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.ComplianceReportResource;
import com.oracle.bmc.fleetappsmanagement.model.ComplianceState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ComplianceReport
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="fleetId")
    private final String fleetId;
    @JsonProperty(value="complianceState")
    private final ComplianceState complianceState;
    @JsonProperty(value="resources")
    private final List<ComplianceReportResource> resources;

    @Deprecated
    @ConstructorProperties(value={"id", "fleetId", "complianceState", "resources"})
    public ComplianceReport(String id, String fleetId, ComplianceState complianceState, List<ComplianceReportResource> resources) {
        this.id = id;
        this.fleetId = fleetId;
        this.complianceState = complianceState;
        this.resources = resources;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public ComplianceState getComplianceState() {
        return this.complianceState;
    }

    public List<ComplianceReportResource> getResources() {
        return this.resources;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ComplianceReport(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", fleetId=").append(String.valueOf(this.fleetId));
        sb.append(", complianceState=").append(String.valueOf((Object)this.complianceState));
        sb.append(", resources=").append(String.valueOf(this.resources));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComplianceReport)) {
            return false;
        }
        ComplianceReport other = (ComplianceReport)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals((Object)this.complianceState, (Object)other.complianceState) && Objects.equals(this.resources, other.resources) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.complianceState == null ? 43 : this.complianceState.hashCode());
        result = result * 59 + (this.resources == null ? 43 : this.resources.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="fleetId")
        private String fleetId;
        @JsonProperty(value="complianceState")
        private ComplianceState complianceState;
        @JsonProperty(value="resources")
        private List<ComplianceReportResource> resources;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            this.__explicitlySet__.add("fleetId");
            return this;
        }

        public Builder complianceState(ComplianceState complianceState) {
            this.complianceState = complianceState;
            this.__explicitlySet__.add("complianceState");
            return this;
        }

        public Builder resources(List<ComplianceReportResource> resources) {
            this.resources = resources;
            this.__explicitlySet__.add("resources");
            return this;
        }

        public ComplianceReport build() {
            ComplianceReport model = new ComplianceReport(this.id, this.fleetId, this.complianceState, this.resources);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ComplianceReport model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("fleetId")) {
                this.fleetId(model.getFleetId());
            }
            if (model.wasPropertyExplicitlySet("complianceState")) {
                this.complianceState(model.getComplianceState());
            }
            if (model.wasPropertyExplicitlySet("resources")) {
                this.resources(model.getResources());
            }
            return this;
        }
    }
}

