/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.ComplianceReportProduct;
import com.oracle.bmc.fleetappsmanagement.model.ComplianceState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ComplianceReportResource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="tenancyId")
    private final String tenancyId;
    @JsonProperty(value="tenancyName")
    private final String tenancyName;
    @JsonProperty(value="compartment")
    private final String compartment;
    @JsonProperty(value="resourceRegion")
    private final String resourceRegion;
    @JsonProperty(value="complianceState")
    private final ComplianceState complianceState;
    @JsonProperty(value="products")
    private final List<ComplianceReportProduct> products;

    @Deprecated
    @ConstructorProperties(value={"resourceId", "resourceName", "resourceType", "tenancyId", "tenancyName", "compartment", "resourceRegion", "complianceState", "products"})
    public ComplianceReportResource(String resourceId, String resourceName, String resourceType, String tenancyId, String tenancyName, String compartment, String resourceRegion, ComplianceState complianceState, List<ComplianceReportProduct> products) {
        this.resourceId = resourceId;
        this.resourceName = resourceName;
        this.resourceType = resourceType;
        this.tenancyId = tenancyId;
        this.tenancyName = tenancyName;
        this.compartment = compartment;
        this.resourceRegion = resourceRegion;
        this.complianceState = complianceState;
        this.products = products;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getTenancyName() {
        return this.tenancyName;
    }

    public String getCompartment() {
        return this.compartment;
    }

    public String getResourceRegion() {
        return this.resourceRegion;
    }

    public ComplianceState getComplianceState() {
        return this.complianceState;
    }

    public List<ComplianceReportProduct> getProducts() {
        return this.products;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ComplianceReportResource(");
        sb.append("super=").append(super.toString());
        sb.append("resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", resourceType=").append(String.valueOf(this.resourceType));
        sb.append(", tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(", tenancyName=").append(String.valueOf(this.tenancyName));
        sb.append(", compartment=").append(String.valueOf(this.compartment));
        sb.append(", resourceRegion=").append(String.valueOf(this.resourceRegion));
        sb.append(", complianceState=").append(String.valueOf((Object)this.complianceState));
        sb.append(", products=").append(String.valueOf(this.products));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComplianceReportResource)) {
            return false;
        }
        ComplianceReportResource other = (ComplianceReportResource)((Object)o);
        return Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.tenancyName, other.tenancyName) && Objects.equals(this.compartment, other.compartment) && Objects.equals(this.resourceRegion, other.resourceRegion) && Objects.equals((Object)this.complianceState, (Object)other.complianceState) && Objects.equals(this.products, other.products) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.tenancyName == null ? 43 : this.tenancyName.hashCode());
        result = result * 59 + (this.compartment == null ? 43 : this.compartment.hashCode());
        result = result * 59 + (this.resourceRegion == null ? 43 : this.resourceRegion.hashCode());
        result = result * 59 + (this.complianceState == null ? 43 : this.complianceState.hashCode());
        result = result * 59 + (this.products == null ? 43 : this.products.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonProperty(value="tenancyName")
        private String tenancyName;
        @JsonProperty(value="compartment")
        private String compartment;
        @JsonProperty(value="resourceRegion")
        private String resourceRegion;
        @JsonProperty(value="complianceState")
        private ComplianceState complianceState;
        @JsonProperty(value="products")
        private List<ComplianceReportProduct> products;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public Builder tenancyName(String tenancyName) {
            this.tenancyName = tenancyName;
            this.__explicitlySet__.add("tenancyName");
            return this;
        }

        public Builder compartment(String compartment) {
            this.compartment = compartment;
            this.__explicitlySet__.add("compartment");
            return this;
        }

        public Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            this.__explicitlySet__.add("resourceRegion");
            return this;
        }

        public Builder complianceState(ComplianceState complianceState) {
            this.complianceState = complianceState;
            this.__explicitlySet__.add("complianceState");
            return this;
        }

        public Builder products(List<ComplianceReportProduct> products) {
            this.products = products;
            this.__explicitlySet__.add("products");
            return this;
        }

        public ComplianceReportResource build() {
            ComplianceReportResource model = new ComplianceReportResource(this.resourceId, this.resourceName, this.resourceType, this.tenancyId, this.tenancyName, this.compartment, this.resourceRegion, this.complianceState, this.products);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ComplianceReportResource model) {
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("tenancyId")) {
                this.tenancyId(model.getTenancyId());
            }
            if (model.wasPropertyExplicitlySet("tenancyName")) {
                this.tenancyName(model.getTenancyName());
            }
            if (model.wasPropertyExplicitlySet("compartment")) {
                this.compartment(model.getCompartment());
            }
            if (model.wasPropertyExplicitlySet("resourceRegion")) {
                this.resourceRegion(model.getResourceRegion());
            }
            if (model.wasPropertyExplicitlySet("complianceState")) {
                this.complianceState(model.getComplianceState());
            }
            if (model.wasPropertyExplicitlySet("products")) {
                this.products(model.getProducts());
            }
            return this;
        }
    }
}

