/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.ComplianceReportPatchDetail;
import com.oracle.bmc.fleetappsmanagement.model.ComplianceState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ComplianceReportTarget
extends ExplicitlySetBmcModel {
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="targetName")
    private final String targetName;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="complianceState")
    private final ComplianceState complianceState;
    @JsonProperty(value="installedPatches")
    private final List<ComplianceReportPatchDetail> installedPatches;
    @JsonProperty(value="recommendedPatches")
    private final List<ComplianceReportPatchDetail> recommendedPatches;

    @Deprecated
    @ConstructorProperties(value={"targetId", "targetName", "version", "complianceState", "installedPatches", "recommendedPatches"})
    public ComplianceReportTarget(String targetId, String targetName, String version, ComplianceState complianceState, List<ComplianceReportPatchDetail> installedPatches, List<ComplianceReportPatchDetail> recommendedPatches) {
        this.targetId = targetId;
        this.targetName = targetName;
        this.version = version;
        this.complianceState = complianceState;
        this.installedPatches = installedPatches;
        this.recommendedPatches = recommendedPatches;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getVersion() {
        return this.version;
    }

    public ComplianceState getComplianceState() {
        return this.complianceState;
    }

    public List<ComplianceReportPatchDetail> getInstalledPatches() {
        return this.installedPatches;
    }

    public List<ComplianceReportPatchDetail> getRecommendedPatches() {
        return this.recommendedPatches;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ComplianceReportTarget(");
        sb.append("super=").append(super.toString());
        sb.append("targetId=").append(String.valueOf(this.targetId));
        sb.append(", targetName=").append(String.valueOf(this.targetName));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", complianceState=").append(String.valueOf((Object)this.complianceState));
        sb.append(", installedPatches=").append(String.valueOf(this.installedPatches));
        sb.append(", recommendedPatches=").append(String.valueOf(this.recommendedPatches));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComplianceReportTarget)) {
            return false;
        }
        ComplianceReportTarget other = (ComplianceReportTarget)((Object)o);
        return Objects.equals(this.targetId, other.targetId) && Objects.equals(this.targetName, other.targetName) && Objects.equals(this.version, other.version) && Objects.equals((Object)this.complianceState, (Object)other.complianceState) && Objects.equals(this.installedPatches, other.installedPatches) && Objects.equals(this.recommendedPatches, other.recommendedPatches) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.targetName == null ? 43 : this.targetName.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.complianceState == null ? 43 : this.complianceState.hashCode());
        result = result * 59 + (this.installedPatches == null ? 43 : this.installedPatches.hashCode());
        result = result * 59 + (this.recommendedPatches == null ? 43 : this.recommendedPatches.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="targetName")
        private String targetName;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="complianceState")
        private ComplianceState complianceState;
        @JsonProperty(value="installedPatches")
        private List<ComplianceReportPatchDetail> installedPatches;
        @JsonProperty(value="recommendedPatches")
        private List<ComplianceReportPatchDetail> recommendedPatches;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder targetName(String targetName) {
            this.targetName = targetName;
            this.__explicitlySet__.add("targetName");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder complianceState(ComplianceState complianceState) {
            this.complianceState = complianceState;
            this.__explicitlySet__.add("complianceState");
            return this;
        }

        public Builder installedPatches(List<ComplianceReportPatchDetail> installedPatches) {
            this.installedPatches = installedPatches;
            this.__explicitlySet__.add("installedPatches");
            return this;
        }

        public Builder recommendedPatches(List<ComplianceReportPatchDetail> recommendedPatches) {
            this.recommendedPatches = recommendedPatches;
            this.__explicitlySet__.add("recommendedPatches");
            return this;
        }

        public ComplianceReportTarget build() {
            ComplianceReportTarget model = new ComplianceReportTarget(this.targetId, this.targetName, this.version, this.complianceState, this.installedPatches, this.recommendedPatches);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ComplianceReportTarget model) {
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("targetName")) {
                this.targetName(model.getTargetName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("complianceState")) {
                this.complianceState(model.getComplianceState());
            }
            if (model.wasPropertyExplicitlySet("installedPatches")) {
                this.installedPatches(model.getInstalledPatches());
            }
            if (model.wasPropertyExplicitlySet("recommendedPatches")) {
                this.recommendedPatches(model.getRecommendedPatches());
            }
            return this;
        }
    }
}

