/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.PauseDetails;
import com.oracle.bmc.fleetappsmanagement.model.TaskNotificationPreferences;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ComponentProperties
extends ExplicitlySetBmcModel {
    @JsonProperty(value="runOn")
    private final String runOn;
    @JsonProperty(value="condition")
    private final String condition;
    @JsonProperty(value="actionOnFailure")
    private final ActionOnFailure actionOnFailure;
    @JsonProperty(value="pauseDetails")
    private final PauseDetails pauseDetails;
    @JsonProperty(value="notificationPreferences")
    private final TaskNotificationPreferences notificationPreferences;

    @Deprecated
    @ConstructorProperties(value={"runOn", "condition", "actionOnFailure", "pauseDetails", "notificationPreferences"})
    public ComponentProperties(String runOn, String condition, ActionOnFailure actionOnFailure, PauseDetails pauseDetails, TaskNotificationPreferences notificationPreferences) {
        this.runOn = runOn;
        this.condition = condition;
        this.actionOnFailure = actionOnFailure;
        this.pauseDetails = pauseDetails;
        this.notificationPreferences = notificationPreferences;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRunOn() {
        return this.runOn;
    }

    public String getCondition() {
        return this.condition;
    }

    public ActionOnFailure getActionOnFailure() {
        return this.actionOnFailure;
    }

    public PauseDetails getPauseDetails() {
        return this.pauseDetails;
    }

    public TaskNotificationPreferences getNotificationPreferences() {
        return this.notificationPreferences;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ComponentProperties(");
        sb.append("super=").append(super.toString());
        sb.append("runOn=").append(String.valueOf(this.runOn));
        sb.append(", condition=").append(String.valueOf(this.condition));
        sb.append(", actionOnFailure=").append(String.valueOf((Object)this.actionOnFailure));
        sb.append(", pauseDetails=").append(String.valueOf((Object)this.pauseDetails));
        sb.append(", notificationPreferences=").append(String.valueOf((Object)this.notificationPreferences));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentProperties)) {
            return false;
        }
        ComponentProperties other = (ComponentProperties)((Object)o);
        return Objects.equals(this.runOn, other.runOn) && Objects.equals(this.condition, other.condition) && Objects.equals((Object)this.actionOnFailure, (Object)other.actionOnFailure) && Objects.equals((Object)this.pauseDetails, (Object)other.pauseDetails) && Objects.equals((Object)this.notificationPreferences, (Object)other.notificationPreferences) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.runOn == null ? 43 : this.runOn.hashCode());
        result = result * 59 + (this.condition == null ? 43 : this.condition.hashCode());
        result = result * 59 + (this.actionOnFailure == null ? 43 : this.actionOnFailure.hashCode());
        result = result * 59 + (this.pauseDetails == null ? 43 : this.pauseDetails.hashCode());
        result = result * 59 + (this.notificationPreferences == null ? 43 : this.notificationPreferences.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ActionOnFailure implements BmcEnum
    {
        Abort("ABORT"),
        Continue("CONTINUE"),
        Rollback("ROLLBACK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ActionOnFailure> map;

        private ActionOnFailure(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActionOnFailure create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ActionOnFailure', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ActionOnFailure.class);
            map = new HashMap<String, ActionOnFailure>();
            for (ActionOnFailure v : ActionOnFailure.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="runOn")
        private String runOn;
        @JsonProperty(value="condition")
        private String condition;
        @JsonProperty(value="actionOnFailure")
        private ActionOnFailure actionOnFailure;
        @JsonProperty(value="pauseDetails")
        private PauseDetails pauseDetails;
        @JsonProperty(value="notificationPreferences")
        private TaskNotificationPreferences notificationPreferences;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder runOn(String runOn) {
            this.runOn = runOn;
            this.__explicitlySet__.add("runOn");
            return this;
        }

        public Builder condition(String condition) {
            this.condition = condition;
            this.__explicitlySet__.add("condition");
            return this;
        }

        public Builder actionOnFailure(ActionOnFailure actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
            this.__explicitlySet__.add("actionOnFailure");
            return this;
        }

        public Builder pauseDetails(PauseDetails pauseDetails) {
            this.pauseDetails = pauseDetails;
            this.__explicitlySet__.add("pauseDetails");
            return this;
        }

        public Builder notificationPreferences(TaskNotificationPreferences notificationPreferences) {
            this.notificationPreferences = notificationPreferences;
            this.__explicitlySet__.add("notificationPreferences");
            return this;
        }

        public ComponentProperties build() {
            ComponentProperties model = new ComponentProperties(this.runOn, this.condition, this.actionOnFailure, this.pauseDetails, this.notificationPreferences);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ComponentProperties model) {
            if (model.wasPropertyExplicitlySet("runOn")) {
                this.runOn(model.getRunOn());
            }
            if (model.wasPropertyExplicitlySet("condition")) {
                this.condition(model.getCondition());
            }
            if (model.wasPropertyExplicitlySet("actionOnFailure")) {
                this.actionOnFailure(model.getActionOnFailure());
            }
            if (model.wasPropertyExplicitlySet("pauseDetails")) {
                this.pauseDetails(model.getPauseDetails());
            }
            if (model.wasPropertyExplicitlySet("notificationPreferences")) {
                this.notificationPreferences(model.getNotificationPreferences());
            }
            return this;
        }
    }
}

