/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.ActivityResourceTarget;
import com.oracle.bmc.fleetappsmanagement.model.JobStatus;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EntityExecutionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="resourceDisplayName")
    private final String resourceDisplayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="sequence")
    private final String sequence;
    @JsonProperty(value="targets")
    private final List<ActivityResourceTarget> targets;
    @JsonProperty(value="status")
    private final JobStatus status;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;

    @Deprecated
    @ConstructorProperties(value={"resourceId", "resourceDisplayName", "description", "sequence", "targets", "status", "timeStarted", "timeEnded"})
    public EntityExecutionDetails(String resourceId, String resourceDisplayName, String description, String sequence, List<ActivityResourceTarget> targets, JobStatus status, Date timeStarted, Date timeEnded) {
        this.resourceId = resourceId;
        this.resourceDisplayName = resourceDisplayName;
        this.description = description;
        this.sequence = sequence;
        this.targets = targets;
        this.status = status;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceDisplayName() {
        return this.resourceDisplayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSequence() {
        return this.sequence;
    }

    public List<ActivityResourceTarget> getTargets() {
        return this.targets;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityExecutionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", resourceDisplayName=").append(String.valueOf(this.resourceDisplayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", sequence=").append(String.valueOf(this.sequence));
        sb.append(", targets=").append(String.valueOf(this.targets));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityExecutionDetails)) {
            return false;
        }
        EntityExecutionDetails other = (EntityExecutionDetails)((Object)o);
        return Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.resourceDisplayName, other.resourceDisplayName) && Objects.equals(this.description, other.description) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.targets, other.targets) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.resourceDisplayName == null ? 43 : this.resourceDisplayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.sequence == null ? 43 : this.sequence.hashCode());
        result = result * 59 + (this.targets == null ? 43 : this.targets.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="resourceDisplayName")
        private String resourceDisplayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="sequence")
        private String sequence;
        @JsonProperty(value="targets")
        private List<ActivityResourceTarget> targets;
        @JsonProperty(value="status")
        private JobStatus status;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder resourceDisplayName(String resourceDisplayName) {
            this.resourceDisplayName = resourceDisplayName;
            this.__explicitlySet__.add("resourceDisplayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder sequence(String sequence) {
            this.sequence = sequence;
            this.__explicitlySet__.add("sequence");
            return this;
        }

        public Builder targets(List<ActivityResourceTarget> targets) {
            this.targets = targets;
            this.__explicitlySet__.add("targets");
            return this;
        }

        public Builder status(JobStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public EntityExecutionDetails build() {
            EntityExecutionDetails model = new EntityExecutionDetails(this.resourceId, this.resourceDisplayName, this.description, this.sequence, this.targets, this.status, this.timeStarted, this.timeEnded);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EntityExecutionDetails model) {
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("resourceDisplayName")) {
                this.resourceDisplayName(model.getResourceDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("sequence")) {
                this.sequence(model.getSequence());
            }
            if (model.wasPropertyExplicitlySet("targets")) {
                this.targets(model.getTargets());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            return this;
        }
    }
}

