/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.JobStatus;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExecutionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="taskRecordId")
    private final String taskRecordId;
    @JsonProperty(value="stepName")
    private final String stepName;
    @JsonProperty(value="processReferenceId")
    private final String processReferenceId;
    @JsonProperty(value="sequence")
    private final String sequence;
    @JsonProperty(value="status")
    private final JobStatus status;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="isRollbackTask")
    private final Boolean isRollbackTask;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "taskRecordId", "stepName", "processReferenceId", "sequence", "status", "targetId", "timeStarted", "timeEnded", "isRollbackTask", "description", "resourceId", "systemTags"})
    public ExecutionSummary(String id, String taskRecordId, String stepName, String processReferenceId, String sequence, JobStatus status, String targetId, Date timeStarted, Date timeEnded, Boolean isRollbackTask, String description, String resourceId, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.taskRecordId = taskRecordId;
        this.stepName = stepName;
        this.processReferenceId = processReferenceId;
        this.sequence = sequence;
        this.status = status;
        this.targetId = targetId;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.isRollbackTask = isRollbackTask;
        this.description = description;
        this.resourceId = resourceId;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getTaskRecordId() {
        return this.taskRecordId;
    }

    public String getStepName() {
        return this.stepName;
    }

    public String getProcessReferenceId() {
        return this.processReferenceId;
    }

    public String getSequence() {
        return this.sequence;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public Boolean getIsRollbackTask() {
        return this.isRollbackTask;
    }

    public String getDescription() {
        return this.description;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExecutionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", taskRecordId=").append(String.valueOf(this.taskRecordId));
        sb.append(", stepName=").append(String.valueOf(this.stepName));
        sb.append(", processReferenceId=").append(String.valueOf(this.processReferenceId));
        sb.append(", sequence=").append(String.valueOf(this.sequence));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", isRollbackTask=").append(String.valueOf(this.isRollbackTask));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExecutionSummary)) {
            return false;
        }
        ExecutionSummary other = (ExecutionSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.taskRecordId, other.taskRecordId) && Objects.equals(this.stepName, other.stepName) && Objects.equals(this.processReferenceId, other.processReferenceId) && Objects.equals(this.sequence, other.sequence) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.isRollbackTask, other.isRollbackTask) && Objects.equals(this.description, other.description) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.taskRecordId == null ? 43 : this.taskRecordId.hashCode());
        result = result * 59 + (this.stepName == null ? 43 : this.stepName.hashCode());
        result = result * 59 + (this.processReferenceId == null ? 43 : this.processReferenceId.hashCode());
        result = result * 59 + (this.sequence == null ? 43 : this.sequence.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.isRollbackTask == null ? 43 : this.isRollbackTask.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="taskRecordId")
        private String taskRecordId;
        @JsonProperty(value="stepName")
        private String stepName;
        @JsonProperty(value="processReferenceId")
        private String processReferenceId;
        @JsonProperty(value="sequence")
        private String sequence;
        @JsonProperty(value="status")
        private JobStatus status;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="isRollbackTask")
        private Boolean isRollbackTask;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder taskRecordId(String taskRecordId) {
            this.taskRecordId = taskRecordId;
            this.__explicitlySet__.add("taskRecordId");
            return this;
        }

        public Builder stepName(String stepName) {
            this.stepName = stepName;
            this.__explicitlySet__.add("stepName");
            return this;
        }

        public Builder processReferenceId(String processReferenceId) {
            this.processReferenceId = processReferenceId;
            this.__explicitlySet__.add("processReferenceId");
            return this;
        }

        public Builder sequence(String sequence) {
            this.sequence = sequence;
            this.__explicitlySet__.add("sequence");
            return this;
        }

        public Builder status(JobStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder isRollbackTask(Boolean isRollbackTask) {
            this.isRollbackTask = isRollbackTask;
            this.__explicitlySet__.add("isRollbackTask");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public ExecutionSummary build() {
            ExecutionSummary model = new ExecutionSummary(this.id, this.taskRecordId, this.stepName, this.processReferenceId, this.sequence, this.status, this.targetId, this.timeStarted, this.timeEnded, this.isRollbackTask, this.description, this.resourceId, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExecutionSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("taskRecordId")) {
                this.taskRecordId(model.getTaskRecordId());
            }
            if (model.wasPropertyExplicitlySet("stepName")) {
                this.stepName(model.getStepName());
            }
            if (model.wasPropertyExplicitlySet("processReferenceId")) {
                this.processReferenceId(model.getProcessReferenceId());
            }
            if (model.wasPropertyExplicitlySet("sequence")) {
                this.sequence(model.getSequence());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("isRollbackTask")) {
                this.isRollbackTask(model.getIsRollbackTask());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

