/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.AssociatedFleetCredentialDetails;
import com.oracle.bmc.fleetappsmanagement.model.AssociatedFleetPropertyDetails;
import com.oracle.bmc.fleetappsmanagement.model.AssociatedFleetResourceDetails;
import com.oracle.bmc.fleetappsmanagement.model.NotificationPreferences;
import com.oracle.bmc.fleetappsmanagement.model.SelectionCriteria;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Fleet
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="resourceRegion")
    private final String resourceRegion;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="fleetType")
    private final FleetType fleetType;
    @JsonProperty(value="products")
    private final List<String> products;
    @JsonProperty(value="applicationType")
    private final String applicationType;
    @JsonProperty(value="environmentType")
    private final String environmentType;
    @JsonProperty(value="groupType")
    private final GroupType groupType;
    @JsonProperty(value="resourceSelectionType")
    private final ResourceSelectionType resourceSelectionType;
    @JsonProperty(value="ruleSelectionCriteria")
    private final SelectionCriteria ruleSelectionCriteria;
    @JsonProperty(value="notificationPreferences")
    private final NotificationPreferences notificationPreferences;
    @JsonProperty(value="resources")
    private final List<AssociatedFleetResourceDetails> resources;
    @JsonProperty(value="properties")
    private final List<AssociatedFleetPropertyDetails> properties;
    @JsonProperty(value="credentials")
    private final List<AssociatedFleetCredentialDetails> credentials;
    @JsonProperty(value="isTargetAutoConfirm")
    private final Boolean isTargetAutoConfirm;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "resourceRegion", "displayName", "description", "timeCreated", "timeUpdated", "fleetType", "products", "applicationType", "environmentType", "groupType", "resourceSelectionType", "ruleSelectionCriteria", "notificationPreferences", "resources", "properties", "credentials", "isTargetAutoConfirm", "lifecycleState", "lifecycleDetails", "freeformTags", "definedTags", "systemTags"})
    public Fleet(String id, String compartmentId, String resourceRegion, String displayName, String description, Date timeCreated, Date timeUpdated, FleetType fleetType, List<String> products, String applicationType, String environmentType, GroupType groupType, ResourceSelectionType resourceSelectionType, SelectionCriteria ruleSelectionCriteria, NotificationPreferences notificationPreferences, List<AssociatedFleetResourceDetails> resources, List<AssociatedFleetPropertyDetails> properties, List<AssociatedFleetCredentialDetails> credentials, Boolean isTargetAutoConfirm, LifecycleState lifecycleState, String lifecycleDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.resourceRegion = resourceRegion;
        this.displayName = displayName;
        this.description = description;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.fleetType = fleetType;
        this.products = products;
        this.applicationType = applicationType;
        this.environmentType = environmentType;
        this.groupType = groupType;
        this.resourceSelectionType = resourceSelectionType;
        this.ruleSelectionCriteria = ruleSelectionCriteria;
        this.notificationPreferences = notificationPreferences;
        this.resources = resources;
        this.properties = properties;
        this.credentials = credentials;
        this.isTargetAutoConfirm = isTargetAutoConfirm;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceRegion() {
        return this.resourceRegion;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public FleetType getFleetType() {
        return this.fleetType;
    }

    public List<String> getProducts() {
        return this.products;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public String getEnvironmentType() {
        return this.environmentType;
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public ResourceSelectionType getResourceSelectionType() {
        return this.resourceSelectionType;
    }

    public SelectionCriteria getRuleSelectionCriteria() {
        return this.ruleSelectionCriteria;
    }

    public NotificationPreferences getNotificationPreferences() {
        return this.notificationPreferences;
    }

    public List<AssociatedFleetResourceDetails> getResources() {
        return this.resources;
    }

    public List<AssociatedFleetPropertyDetails> getProperties() {
        return this.properties;
    }

    public List<AssociatedFleetCredentialDetails> getCredentials() {
        return this.credentials;
    }

    public Boolean getIsTargetAutoConfirm() {
        return this.isTargetAutoConfirm;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Fleet(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", resourceRegion=").append(String.valueOf(this.resourceRegion));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", fleetType=").append(String.valueOf((Object)this.fleetType));
        sb.append(", products=").append(String.valueOf(this.products));
        sb.append(", applicationType=").append(String.valueOf(this.applicationType));
        sb.append(", environmentType=").append(String.valueOf(this.environmentType));
        sb.append(", groupType=").append(String.valueOf((Object)this.groupType));
        sb.append(", resourceSelectionType=").append(String.valueOf((Object)this.resourceSelectionType));
        sb.append(", ruleSelectionCriteria=").append(String.valueOf((Object)this.ruleSelectionCriteria));
        sb.append(", notificationPreferences=").append(String.valueOf((Object)this.notificationPreferences));
        sb.append(", resources=").append(String.valueOf(this.resources));
        sb.append(", properties=").append(String.valueOf(this.properties));
        sb.append(", credentials=").append(String.valueOf(this.credentials));
        sb.append(", isTargetAutoConfirm=").append(String.valueOf(this.isTargetAutoConfirm));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Fleet)) {
            return false;
        }
        Fleet other = (Fleet)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resourceRegion, other.resourceRegion) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.fleetType, (Object)other.fleetType) && Objects.equals(this.products, other.products) && Objects.equals(this.applicationType, other.applicationType) && Objects.equals(this.environmentType, other.environmentType) && Objects.equals((Object)this.groupType, (Object)other.groupType) && Objects.equals((Object)this.resourceSelectionType, (Object)other.resourceSelectionType) && Objects.equals((Object)this.ruleSelectionCriteria, (Object)other.ruleSelectionCriteria) && Objects.equals((Object)this.notificationPreferences, (Object)other.notificationPreferences) && Objects.equals(this.resources, other.resources) && Objects.equals(this.properties, other.properties) && Objects.equals(this.credentials, other.credentials) && Objects.equals(this.isTargetAutoConfirm, other.isTargetAutoConfirm) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resourceRegion == null ? 43 : this.resourceRegion.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.fleetType == null ? 43 : this.fleetType.hashCode());
        result = result * 59 + (this.products == null ? 43 : this.products.hashCode());
        result = result * 59 + (this.applicationType == null ? 43 : this.applicationType.hashCode());
        result = result * 59 + (this.environmentType == null ? 43 : this.environmentType.hashCode());
        result = result * 59 + (this.groupType == null ? 43 : this.groupType.hashCode());
        result = result * 59 + (this.resourceSelectionType == null ? 43 : this.resourceSelectionType.hashCode());
        result = result * 59 + (this.ruleSelectionCriteria == null ? 43 : this.ruleSelectionCriteria.hashCode());
        result = result * 59 + (this.notificationPreferences == null ? 43 : this.notificationPreferences.hashCode());
        result = result * 59 + (this.resources == null ? 43 : this.resources.hashCode());
        result = result * 59 + (this.properties == null ? 43 : this.properties.hashCode());
        result = result * 59 + (this.credentials == null ? 43 : this.credentials.hashCode());
        result = result * 59 + (this.isTargetAutoConfirm == null ? 43 : this.isTargetAutoConfirm.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Creating("CREATING"),
        Deleted("DELETED"),
        Deleting("DELETING"),
        Failed("FAILED"),
        Updating("UPDATING"),
        NeedsAttention("NEEDS_ATTENTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ResourceSelectionType implements BmcEnum
    {
        Dynamic("DYNAMIC"),
        Manual("MANUAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceSelectionType> map;

        private ResourceSelectionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceSelectionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceSelectionType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceSelectionType.class);
            map = new HashMap<String, ResourceSelectionType>();
            for (ResourceSelectionType v : ResourceSelectionType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum GroupType implements BmcEnum
    {
        Environment("ENVIRONMENT"),
        Product("PRODUCT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, GroupType> map;

        private GroupType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GroupType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'GroupType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(GroupType.class);
            map = new HashMap<String, GroupType>();
            for (GroupType v : GroupType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum FleetType implements BmcEnum
    {
        Product("PRODUCT"),
        Environment("ENVIRONMENT"),
        Generic("GENERIC"),
        Group("GROUP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FleetType> map;

        private FleetType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FleetType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FleetType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FleetType.class);
            map = new HashMap<String, FleetType>();
            for (FleetType v : FleetType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="resourceRegion")
        private String resourceRegion;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="fleetType")
        private FleetType fleetType;
        @JsonProperty(value="products")
        private List<String> products;
        @JsonProperty(value="applicationType")
        private String applicationType;
        @JsonProperty(value="environmentType")
        private String environmentType;
        @JsonProperty(value="groupType")
        private GroupType groupType;
        @JsonProperty(value="resourceSelectionType")
        private ResourceSelectionType resourceSelectionType;
        @JsonProperty(value="ruleSelectionCriteria")
        private SelectionCriteria ruleSelectionCriteria;
        @JsonProperty(value="notificationPreferences")
        private NotificationPreferences notificationPreferences;
        @JsonProperty(value="resources")
        private List<AssociatedFleetResourceDetails> resources;
        @JsonProperty(value="properties")
        private List<AssociatedFleetPropertyDetails> properties;
        @JsonProperty(value="credentials")
        private List<AssociatedFleetCredentialDetails> credentials;
        @JsonProperty(value="isTargetAutoConfirm")
        private Boolean isTargetAutoConfirm;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            this.__explicitlySet__.add("resourceRegion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder fleetType(FleetType fleetType) {
            this.fleetType = fleetType;
            this.__explicitlySet__.add("fleetType");
            return this;
        }

        public Builder products(List<String> products) {
            this.products = products;
            this.__explicitlySet__.add("products");
            return this;
        }

        public Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            this.__explicitlySet__.add("applicationType");
            return this;
        }

        public Builder environmentType(String environmentType) {
            this.environmentType = environmentType;
            this.__explicitlySet__.add("environmentType");
            return this;
        }

        public Builder groupType(GroupType groupType) {
            this.groupType = groupType;
            this.__explicitlySet__.add("groupType");
            return this;
        }

        public Builder resourceSelectionType(ResourceSelectionType resourceSelectionType) {
            this.resourceSelectionType = resourceSelectionType;
            this.__explicitlySet__.add("resourceSelectionType");
            return this;
        }

        public Builder ruleSelectionCriteria(SelectionCriteria ruleSelectionCriteria) {
            this.ruleSelectionCriteria = ruleSelectionCriteria;
            this.__explicitlySet__.add("ruleSelectionCriteria");
            return this;
        }

        public Builder notificationPreferences(NotificationPreferences notificationPreferences) {
            this.notificationPreferences = notificationPreferences;
            this.__explicitlySet__.add("notificationPreferences");
            return this;
        }

        public Builder resources(List<AssociatedFleetResourceDetails> resources) {
            this.resources = resources;
            this.__explicitlySet__.add("resources");
            return this;
        }

        public Builder properties(List<AssociatedFleetPropertyDetails> properties) {
            this.properties = properties;
            this.__explicitlySet__.add("properties");
            return this;
        }

        public Builder credentials(List<AssociatedFleetCredentialDetails> credentials) {
            this.credentials = credentials;
            this.__explicitlySet__.add("credentials");
            return this;
        }

        public Builder isTargetAutoConfirm(Boolean isTargetAutoConfirm) {
            this.isTargetAutoConfirm = isTargetAutoConfirm;
            this.__explicitlySet__.add("isTargetAutoConfirm");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Fleet build() {
            Fleet model = new Fleet(this.id, this.compartmentId, this.resourceRegion, this.displayName, this.description, this.timeCreated, this.timeUpdated, this.fleetType, this.products, this.applicationType, this.environmentType, this.groupType, this.resourceSelectionType, this.ruleSelectionCriteria, this.notificationPreferences, this.resources, this.properties, this.credentials, this.isTargetAutoConfirm, this.lifecycleState, this.lifecycleDetails, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Fleet model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("resourceRegion")) {
                this.resourceRegion(model.getResourceRegion());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("fleetType")) {
                this.fleetType(model.getFleetType());
            }
            if (model.wasPropertyExplicitlySet("products")) {
                this.products(model.getProducts());
            }
            if (model.wasPropertyExplicitlySet("applicationType")) {
                this.applicationType(model.getApplicationType());
            }
            if (model.wasPropertyExplicitlySet("environmentType")) {
                this.environmentType(model.getEnvironmentType());
            }
            if (model.wasPropertyExplicitlySet("groupType")) {
                this.groupType(model.getGroupType());
            }
            if (model.wasPropertyExplicitlySet("resourceSelectionType")) {
                this.resourceSelectionType(model.getResourceSelectionType());
            }
            if (model.wasPropertyExplicitlySet("ruleSelectionCriteria")) {
                this.ruleSelectionCriteria(model.getRuleSelectionCriteria());
            }
            if (model.wasPropertyExplicitlySet("notificationPreferences")) {
                this.notificationPreferences(model.getNotificationPreferences());
            }
            if (model.wasPropertyExplicitlySet("resources")) {
                this.resources(model.getResources());
            }
            if (model.wasPropertyExplicitlySet("properties")) {
                this.properties(model.getProperties());
            }
            if (model.wasPropertyExplicitlySet("credentials")) {
                this.credentials(model.getCredentials());
            }
            if (model.wasPropertyExplicitlySet("isTargetAutoConfirm")) {
                this.isTargetAutoConfirm(model.getIsTargetAutoConfirm());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

