/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.CredentialDetails;
import com.oracle.bmc.fleetappsmanagement.model.CredentialEntitySpecificDetails;
import com.oracle.bmc.fleetappsmanagement.model.FleetCredential;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FleetCredentialSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="entitySpecifics")
    private final CredentialEntitySpecificDetails entitySpecifics;
    @JsonProperty(value="user")
    private final CredentialDetails user;
    @JsonProperty(value="password")
    private final CredentialDetails password;
    @JsonProperty(value="lifecycleState")
    private final FleetCredential.LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "timeCreated", "timeUpdated", "entitySpecifics", "user", "password", "lifecycleState", "lifecycleDetails", "systemTags"})
    public FleetCredentialSummary(String id, String displayName, String compartmentId, Date timeCreated, Date timeUpdated, CredentialEntitySpecificDetails entitySpecifics, CredentialDetails user, CredentialDetails password, FleetCredential.LifecycleState lifecycleState, String lifecycleDetails, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.entitySpecifics = entitySpecifics;
        this.user = user;
        this.password = password;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public CredentialEntitySpecificDetails getEntitySpecifics() {
        return this.entitySpecifics;
    }

    public CredentialDetails getUser() {
        return this.user;
    }

    public CredentialDetails getPassword() {
        return this.password;
    }

    public FleetCredential.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FleetCredentialSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", entitySpecifics=").append(String.valueOf((Object)this.entitySpecifics));
        sb.append(", user=").append(String.valueOf((Object)this.user));
        sb.append(", password=").append(String.valueOf((Object)this.password));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FleetCredentialSummary)) {
            return false;
        }
        FleetCredentialSummary other = (FleetCredentialSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.entitySpecifics, (Object)other.entitySpecifics) && Objects.equals((Object)this.user, (Object)other.user) && Objects.equals((Object)this.password, (Object)other.password) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.entitySpecifics == null ? 43 : this.entitySpecifics.hashCode());
        result = result * 59 + (this.user == null ? 43 : this.user.hashCode());
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="entitySpecifics")
        private CredentialEntitySpecificDetails entitySpecifics;
        @JsonProperty(value="user")
        private CredentialDetails user;
        @JsonProperty(value="password")
        private CredentialDetails password;
        @JsonProperty(value="lifecycleState")
        private FleetCredential.LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder entitySpecifics(CredentialEntitySpecificDetails entitySpecifics) {
            this.entitySpecifics = entitySpecifics;
            this.__explicitlySet__.add("entitySpecifics");
            return this;
        }

        public Builder user(CredentialDetails user) {
            this.user = user;
            this.__explicitlySet__.add("user");
            return this;
        }

        public Builder password(CredentialDetails password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder lifecycleState(FleetCredential.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public FleetCredentialSummary build() {
            FleetCredentialSummary model = new FleetCredentialSummary(this.id, this.displayName, this.compartmentId, this.timeCreated, this.timeUpdated, this.entitySpecifics, this.user, this.password, this.lifecycleState, this.lifecycleDetails, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FleetCredentialSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("entitySpecifics")) {
                this.entitySpecifics(model.getEntitySpecifics());
            }
            if (model.wasPropertyExplicitlySet("user")) {
                this.user(model.getUser());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

