/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.ComplianceState;
import com.oracle.bmc.fleetappsmanagement.model.FleetTarget;
import com.oracle.bmc.fleetappsmanagement.model.TargetResource;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FleetTargetSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="product")
    private final String product;
    @JsonProperty(value="resource")
    private final TargetResource resource;
    @JsonProperty(value="complianceState")
    private final ComplianceState complianceState;
    @JsonProperty(value="timeOfLastSuccessfulDiscovery")
    private final Date timeOfLastSuccessfulDiscovery;
    @JsonProperty(value="timeOfLastDiscoveryAttempt")
    private final Date timeOfLastDiscoveryAttempt;
    @JsonProperty(value="isLastDiscoveryAttemptSuccessful")
    private final Boolean isLastDiscoveryAttemptSuccessful;
    @JsonProperty(value="lifecycleState")
    private final FleetTarget.LifecycleState lifecycleState;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "version", "product", "resource", "complianceState", "timeOfLastSuccessfulDiscovery", "timeOfLastDiscoveryAttempt", "isLastDiscoveryAttemptSuccessful", "lifecycleState", "systemTags"})
    public FleetTargetSummary(String id, String compartmentId, String displayName, String version, String product, TargetResource resource, ComplianceState complianceState, Date timeOfLastSuccessfulDiscovery, Date timeOfLastDiscoveryAttempt, Boolean isLastDiscoveryAttemptSuccessful, FleetTarget.LifecycleState lifecycleState, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.version = version;
        this.product = product;
        this.resource = resource;
        this.complianceState = complianceState;
        this.timeOfLastSuccessfulDiscovery = timeOfLastSuccessfulDiscovery;
        this.timeOfLastDiscoveryAttempt = timeOfLastDiscoveryAttempt;
        this.isLastDiscoveryAttemptSuccessful = isLastDiscoveryAttemptSuccessful;
        this.lifecycleState = lifecycleState;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProduct() {
        return this.product;
    }

    public TargetResource getResource() {
        return this.resource;
    }

    public ComplianceState getComplianceState() {
        return this.complianceState;
    }

    public Date getTimeOfLastSuccessfulDiscovery() {
        return this.timeOfLastSuccessfulDiscovery;
    }

    public Date getTimeOfLastDiscoveryAttempt() {
        return this.timeOfLastDiscoveryAttempt;
    }

    public Boolean getIsLastDiscoveryAttemptSuccessful() {
        return this.isLastDiscoveryAttemptSuccessful;
    }

    public FleetTarget.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FleetTargetSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", product=").append(String.valueOf(this.product));
        sb.append(", resource=").append(String.valueOf((Object)this.resource));
        sb.append(", complianceState=").append(String.valueOf((Object)this.complianceState));
        sb.append(", timeOfLastSuccessfulDiscovery=").append(String.valueOf(this.timeOfLastSuccessfulDiscovery));
        sb.append(", timeOfLastDiscoveryAttempt=").append(String.valueOf(this.timeOfLastDiscoveryAttempt));
        sb.append(", isLastDiscoveryAttemptSuccessful=").append(String.valueOf(this.isLastDiscoveryAttemptSuccessful));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FleetTargetSummary)) {
            return false;
        }
        FleetTargetSummary other = (FleetTargetSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.version, other.version) && Objects.equals(this.product, other.product) && Objects.equals((Object)this.resource, (Object)other.resource) && Objects.equals((Object)this.complianceState, (Object)other.complianceState) && Objects.equals(this.timeOfLastSuccessfulDiscovery, other.timeOfLastSuccessfulDiscovery) && Objects.equals(this.timeOfLastDiscoveryAttempt, other.timeOfLastDiscoveryAttempt) && Objects.equals(this.isLastDiscoveryAttemptSuccessful, other.isLastDiscoveryAttemptSuccessful) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.product == null ? 43 : this.product.hashCode());
        result = result * 59 + (this.resource == null ? 43 : this.resource.hashCode());
        result = result * 59 + (this.complianceState == null ? 43 : this.complianceState.hashCode());
        result = result * 59 + (this.timeOfLastSuccessfulDiscovery == null ? 43 : this.timeOfLastSuccessfulDiscovery.hashCode());
        result = result * 59 + (this.timeOfLastDiscoveryAttempt == null ? 43 : this.timeOfLastDiscoveryAttempt.hashCode());
        result = result * 59 + (this.isLastDiscoveryAttemptSuccessful == null ? 43 : this.isLastDiscoveryAttemptSuccessful.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="product")
        private String product;
        @JsonProperty(value="resource")
        private TargetResource resource;
        @JsonProperty(value="complianceState")
        private ComplianceState complianceState;
        @JsonProperty(value="timeOfLastSuccessfulDiscovery")
        private Date timeOfLastSuccessfulDiscovery;
        @JsonProperty(value="timeOfLastDiscoveryAttempt")
        private Date timeOfLastDiscoveryAttempt;
        @JsonProperty(value="isLastDiscoveryAttemptSuccessful")
        private Boolean isLastDiscoveryAttemptSuccessful;
        @JsonProperty(value="lifecycleState")
        private FleetTarget.LifecycleState lifecycleState;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder product(String product) {
            this.product = product;
            this.__explicitlySet__.add("product");
            return this;
        }

        public Builder resource(TargetResource resource) {
            this.resource = resource;
            this.__explicitlySet__.add("resource");
            return this;
        }

        public Builder complianceState(ComplianceState complianceState) {
            this.complianceState = complianceState;
            this.__explicitlySet__.add("complianceState");
            return this;
        }

        public Builder timeOfLastSuccessfulDiscovery(Date timeOfLastSuccessfulDiscovery) {
            this.timeOfLastSuccessfulDiscovery = timeOfLastSuccessfulDiscovery;
            this.__explicitlySet__.add("timeOfLastSuccessfulDiscovery");
            return this;
        }

        public Builder timeOfLastDiscoveryAttempt(Date timeOfLastDiscoveryAttempt) {
            this.timeOfLastDiscoveryAttempt = timeOfLastDiscoveryAttempt;
            this.__explicitlySet__.add("timeOfLastDiscoveryAttempt");
            return this;
        }

        public Builder isLastDiscoveryAttemptSuccessful(Boolean isLastDiscoveryAttemptSuccessful) {
            this.isLastDiscoveryAttemptSuccessful = isLastDiscoveryAttemptSuccessful;
            this.__explicitlySet__.add("isLastDiscoveryAttemptSuccessful");
            return this;
        }

        public Builder lifecycleState(FleetTarget.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public FleetTargetSummary build() {
            FleetTargetSummary model = new FleetTargetSummary(this.id, this.compartmentId, this.displayName, this.version, this.product, this.resource, this.complianceState, this.timeOfLastSuccessfulDiscovery, this.timeOfLastDiscoveryAttempt, this.isLastDiscoveryAttemptSuccessful, this.lifecycleState, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FleetTargetSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("product")) {
                this.product(model.getProduct());
            }
            if (model.wasPropertyExplicitlySet("resource")) {
                this.resource(model.getResource());
            }
            if (model.wasPropertyExplicitlySet("complianceState")) {
                this.complianceState(model.getComplianceState());
            }
            if (model.wasPropertyExplicitlySet("timeOfLastSuccessfulDiscovery")) {
                this.timeOfLastSuccessfulDiscovery(model.getTimeOfLastSuccessfulDiscovery());
            }
            if (model.wasPropertyExplicitlySet("timeOfLastDiscoveryAttempt")) {
                this.timeOfLastDiscoveryAttempt(model.getTimeOfLastDiscoveryAttempt());
            }
            if (model.wasPropertyExplicitlySet("isLastDiscoveryAttemptSuccessful")) {
                this.isLastDiscoveryAttemptSuccessful(model.getIsLastDiscoveryAttemptSuccessful());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

