/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.EntityExecutionDetails;
import com.oracle.bmc.fleetappsmanagement.model.JobStatus;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JobActivity
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="status")
    private final JobStatus status;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="runbookId")
    private final String runbookId;
    @JsonProperty(value="runbookName")
    private final String runbookName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="resourceLevelExecutions")
    private final List<EntityExecutionDetails> resourceLevelExecutions;

    @Deprecated
    @ConstructorProperties(value={"id", "status", "timeStarted", "timeEnded", "runbookId", "runbookName", "description", "resourceLevelExecutions"})
    public JobActivity(String id, JobStatus status, Date timeStarted, Date timeEnded, String runbookId, String runbookName, String description, List<EntityExecutionDetails> resourceLevelExecutions) {
        this.id = id;
        this.status = status;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.runbookId = runbookId;
        this.runbookName = runbookName;
        this.description = description;
        this.resourceLevelExecutions = resourceLevelExecutions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public String getRunbookId() {
        return this.runbookId;
    }

    public String getRunbookName() {
        return this.runbookName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<EntityExecutionDetails> getResourceLevelExecutions() {
        return this.resourceLevelExecutions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JobActivity(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", runbookId=").append(String.valueOf(this.runbookId));
        sb.append(", runbookName=").append(String.valueOf(this.runbookName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", resourceLevelExecutions=").append(String.valueOf(this.resourceLevelExecutions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobActivity)) {
            return false;
        }
        JobActivity other = (JobActivity)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.runbookId, other.runbookId) && Objects.equals(this.runbookName, other.runbookName) && Objects.equals(this.description, other.description) && Objects.equals(this.resourceLevelExecutions, other.resourceLevelExecutions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.runbookId == null ? 43 : this.runbookId.hashCode());
        result = result * 59 + (this.runbookName == null ? 43 : this.runbookName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.resourceLevelExecutions == null ? 43 : this.resourceLevelExecutions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="status")
        private JobStatus status;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="runbookId")
        private String runbookId;
        @JsonProperty(value="runbookName")
        private String runbookName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="resourceLevelExecutions")
        private List<EntityExecutionDetails> resourceLevelExecutions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder status(JobStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder runbookId(String runbookId) {
            this.runbookId = runbookId;
            this.__explicitlySet__.add("runbookId");
            return this;
        }

        public Builder runbookName(String runbookName) {
            this.runbookName = runbookName;
            this.__explicitlySet__.add("runbookName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder resourceLevelExecutions(List<EntityExecutionDetails> resourceLevelExecutions) {
            this.resourceLevelExecutions = resourceLevelExecutions;
            this.__explicitlySet__.add("resourceLevelExecutions");
            return this;
        }

        public JobActivity build() {
            JobActivity model = new JobActivity(this.id, this.status, this.timeStarted, this.timeEnded, this.runbookId, this.runbookName, this.description, this.resourceLevelExecutions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JobActivity model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("runbookId")) {
                this.runbookId(model.getRunbookId());
            }
            if (model.wasPropertyExplicitlySet("runbookName")) {
                this.runbookName(model.getRunbookName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("resourceLevelExecutions")) {
                this.resourceLevelExecutions(model.getResourceLevelExecutions());
            }
            return this;
        }
    }
}

