/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.CredentialDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="credentialType")
@JsonFilter(value="explicitlySetFilter")
public final class KeyEncryptionCredentialDetails
extends CredentialDetails {
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="keyVersion")
    private final String keyVersion;
    @JsonProperty(value="vaultId")
    private final String vaultId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public KeyEncryptionCredentialDetails(String value, String keyId, String keyVersion, String vaultId) {
        this.value = value;
        this.keyId = keyId;
        this.keyVersion = keyVersion;
        this.vaultId = vaultId;
    }

    public String getValue() {
        return this.value;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyVersion() {
        return this.keyVersion;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KeyEncryptionCredentialDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", keyId=").append(String.valueOf(this.keyId));
        sb.append(", keyVersion=").append(String.valueOf(this.keyVersion));
        sb.append(", vaultId=").append(String.valueOf(this.vaultId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyEncryptionCredentialDetails)) {
            return false;
        }
        KeyEncryptionCredentialDetails other = (KeyEncryptionCredentialDetails)((Object)o);
        return Objects.equals(this.value, other.value) && Objects.equals(this.keyId, other.keyId) && Objects.equals(this.keyVersion, other.keyVersion) && Objects.equals(this.vaultId, other.vaultId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.keyVersion == null ? 43 : this.keyVersion.hashCode());
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="keyVersion")
        private String keyVersion;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder keyVersion(String keyVersion) {
            this.keyVersion = keyVersion;
            this.__explicitlySet__.add("keyVersion");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public KeyEncryptionCredentialDetails build() {
            KeyEncryptionCredentialDetails model = new KeyEncryptionCredentialDetails(this.value, this.keyId, this.keyVersion, this.vaultId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KeyEncryptionCredentialDetails model) {
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("keyVersion")) {
                this.keyVersion(model.getKeyVersion());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            return this;
        }
    }
}

