/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.Preferences;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NotificationPreferences
extends ExplicitlySetBmcModel {
    @JsonProperty(value="topicId")
    private final String topicId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="preferences")
    private final Preferences preferences;

    @Deprecated
    @ConstructorProperties(value={"topicId", "compartmentId", "preferences"})
    public NotificationPreferences(String topicId, String compartmentId, Preferences preferences) {
        this.topicId = topicId;
        this.compartmentId = compartmentId;
        this.preferences = preferences;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTopicId() {
        return this.topicId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NotificationPreferences(");
        sb.append("super=").append(super.toString());
        sb.append("topicId=").append(String.valueOf(this.topicId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", preferences=").append(String.valueOf((Object)this.preferences));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationPreferences)) {
            return false;
        }
        NotificationPreferences other = (NotificationPreferences)((Object)o);
        return Objects.equals(this.topicId, other.topicId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.preferences, (Object)other.preferences) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.topicId == null ? 43 : this.topicId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.preferences == null ? 43 : this.preferences.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="topicId")
        private String topicId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="preferences")
        private Preferences preferences;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder topicId(String topicId) {
            this.topicId = topicId;
            this.__explicitlySet__.add("topicId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder preferences(Preferences preferences) {
            this.preferences = preferences;
            this.__explicitlySet__.add("preferences");
            return this;
        }

        public NotificationPreferences build() {
            NotificationPreferences model = new NotificationPreferences(this.topicId, this.compartmentId, this.preferences);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NotificationPreferences model) {
            if (model.wasPropertyExplicitlySet("topicId")) {
                this.topicId(model.getTopicId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("preferences")) {
                this.preferences(model.getPreferences());
            }
            return this;
        }
    }
}

