/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.Onboarding;
import com.oracle.bmc.fleetappsmanagement.model.OnboardingPolicySummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OnboardingSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="resourceRegion")
    private final String resourceRegion;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="isFamsTagEnabled")
    private final Boolean isFamsTagEnabled;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="isCostTrackingTagEnabled")
    private final Boolean isCostTrackingTagEnabled;
    @JsonProperty(value="appliedPolicies")
    private final OnboardingPolicySummary appliedPolicies;
    @JsonProperty(value="discoveryFrequency")
    private final String discoveryFrequency;
    @JsonProperty(value="lifecycleState")
    private final Onboarding.LifecycleState lifecycleState;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "resourceRegion", "timeCreated", "timeUpdated", "isFamsTagEnabled", "version", "isCostTrackingTagEnabled", "appliedPolicies", "discoveryFrequency", "lifecycleState", "systemTags"})
    public OnboardingSummary(String id, String compartmentId, String resourceRegion, Date timeCreated, Date timeUpdated, Boolean isFamsTagEnabled, String version, Boolean isCostTrackingTagEnabled, OnboardingPolicySummary appliedPolicies, String discoveryFrequency, Onboarding.LifecycleState lifecycleState, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.resourceRegion = resourceRegion;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.isFamsTagEnabled = isFamsTagEnabled;
        this.version = version;
        this.isCostTrackingTagEnabled = isCostTrackingTagEnabled;
        this.appliedPolicies = appliedPolicies;
        this.discoveryFrequency = discoveryFrequency;
        this.lifecycleState = lifecycleState;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceRegion() {
        return this.resourceRegion;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Boolean getIsFamsTagEnabled() {
        return this.isFamsTagEnabled;
    }

    public String getVersion() {
        return this.version;
    }

    public Boolean getIsCostTrackingTagEnabled() {
        return this.isCostTrackingTagEnabled;
    }

    public OnboardingPolicySummary getAppliedPolicies() {
        return this.appliedPolicies;
    }

    public String getDiscoveryFrequency() {
        return this.discoveryFrequency;
    }

    public Onboarding.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OnboardingSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", resourceRegion=").append(String.valueOf(this.resourceRegion));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", isFamsTagEnabled=").append(String.valueOf(this.isFamsTagEnabled));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", isCostTrackingTagEnabled=").append(String.valueOf(this.isCostTrackingTagEnabled));
        sb.append(", appliedPolicies=").append(String.valueOf((Object)this.appliedPolicies));
        sb.append(", discoveryFrequency=").append(String.valueOf(this.discoveryFrequency));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OnboardingSummary)) {
            return false;
        }
        OnboardingSummary other = (OnboardingSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resourceRegion, other.resourceRegion) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.isFamsTagEnabled, other.isFamsTagEnabled) && Objects.equals(this.version, other.version) && Objects.equals(this.isCostTrackingTagEnabled, other.isCostTrackingTagEnabled) && Objects.equals((Object)this.appliedPolicies, (Object)other.appliedPolicies) && Objects.equals(this.discoveryFrequency, other.discoveryFrequency) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resourceRegion == null ? 43 : this.resourceRegion.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.isFamsTagEnabled == null ? 43 : this.isFamsTagEnabled.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.isCostTrackingTagEnabled == null ? 43 : this.isCostTrackingTagEnabled.hashCode());
        result = result * 59 + (this.appliedPolicies == null ? 43 : this.appliedPolicies.hashCode());
        result = result * 59 + (this.discoveryFrequency == null ? 43 : this.discoveryFrequency.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="resourceRegion")
        private String resourceRegion;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="isFamsTagEnabled")
        private Boolean isFamsTagEnabled;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="isCostTrackingTagEnabled")
        private Boolean isCostTrackingTagEnabled;
        @JsonProperty(value="appliedPolicies")
        private OnboardingPolicySummary appliedPolicies;
        @JsonProperty(value="discoveryFrequency")
        private String discoveryFrequency;
        @JsonProperty(value="lifecycleState")
        private Onboarding.LifecycleState lifecycleState;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            this.__explicitlySet__.add("resourceRegion");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder isFamsTagEnabled(Boolean isFamsTagEnabled) {
            this.isFamsTagEnabled = isFamsTagEnabled;
            this.__explicitlySet__.add("isFamsTagEnabled");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder isCostTrackingTagEnabled(Boolean isCostTrackingTagEnabled) {
            this.isCostTrackingTagEnabled = isCostTrackingTagEnabled;
            this.__explicitlySet__.add("isCostTrackingTagEnabled");
            return this;
        }

        public Builder appliedPolicies(OnboardingPolicySummary appliedPolicies) {
            this.appliedPolicies = appliedPolicies;
            this.__explicitlySet__.add("appliedPolicies");
            return this;
        }

        public Builder discoveryFrequency(String discoveryFrequency) {
            this.discoveryFrequency = discoveryFrequency;
            this.__explicitlySet__.add("discoveryFrequency");
            return this;
        }

        public Builder lifecycleState(Onboarding.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public OnboardingSummary build() {
            OnboardingSummary model = new OnboardingSummary(this.id, this.compartmentId, this.resourceRegion, this.timeCreated, this.timeUpdated, this.isFamsTagEnabled, this.version, this.isCostTrackingTagEnabled, this.appliedPolicies, this.discoveryFrequency, this.lifecycleState, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OnboardingSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("resourceRegion")) {
                this.resourceRegion(model.getResourceRegion());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("isFamsTagEnabled")) {
                this.isFamsTagEnabled(model.getIsFamsTagEnabled());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("isCostTrackingTagEnabled")) {
                this.isCostTrackingTagEnabled(model.getIsCostTrackingTagEnabled());
            }
            if (model.wasPropertyExplicitlySet("appliedPolicies")) {
                this.appliedPolicies(model.getAppliedPolicies());
            }
            if (model.wasPropertyExplicitlySet("discoveryFrequency")) {
                this.discoveryFrequency(model.getDiscoveryFrequency());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

