/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.PatchSelectionDetails;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="selectionType")
@JsonFilter(value="explicitlySetFilter")
public final class PatchLevelSelectionDetails
extends PatchSelectionDetails {
    @JsonProperty(value="patchLevel")
    private final PatchLevel patchLevel;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PatchLevelSelectionDetails(PatchLevel patchLevel) {
        this.patchLevel = patchLevel;
    }

    public PatchLevel getPatchLevel() {
        return this.patchLevel;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PatchLevelSelectionDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", patchLevel=").append(String.valueOf((Object)this.patchLevel));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchLevelSelectionDetails)) {
            return false;
        }
        PatchLevelSelectionDetails other = (PatchLevelSelectionDetails)((Object)o);
        return Objects.equals((Object)this.patchLevel, (Object)other.patchLevel) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.patchLevel == null ? 43 : this.patchLevel.hashCode());
        return result;
    }

    public static enum PatchLevel implements BmcEnum
    {
        Latest("LATEST"),
        LatestMinusOne("LATEST_MINUS_ONE"),
        LatestMinusTwo("LATEST_MINUS_TWO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PatchLevel> map;

        private PatchLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PatchLevel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PatchLevel.class);
            map = new HashMap<String, PatchLevel>();
            for (PatchLevel v : PatchLevel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="patchLevel")
        private PatchLevel patchLevel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder patchLevel(PatchLevel patchLevel) {
            this.patchLevel = patchLevel;
            this.__explicitlySet__.add("patchLevel");
            return this;
        }

        public PatchLevelSelectionDetails build() {
            PatchLevelSelectionDetails model = new PatchLevelSelectionDetails(this.patchLevel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PatchLevelSelectionDetails model) {
            if (model.wasPropertyExplicitlySet("patchLevel")) {
                this.patchLevel(model.getPatchLevel());
            }
            return this;
        }
    }
}

