/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PatchProduct
extends ExplicitlySetBmcModel {
    @JsonProperty(value="platformConfigurationId")
    private final String platformConfigurationId;
    @JsonProperty(value="version")
    private final String version;

    @Deprecated
    @ConstructorProperties(value={"platformConfigurationId", "version"})
    public PatchProduct(String platformConfigurationId, String version) {
        this.platformConfigurationId = platformConfigurationId;
        this.version = version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPlatformConfigurationId() {
        return this.platformConfigurationId;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PatchProduct(");
        sb.append("super=").append(super.toString());
        sb.append("platformConfigurationId=").append(String.valueOf(this.platformConfigurationId));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchProduct)) {
            return false;
        }
        PatchProduct other = (PatchProduct)((Object)o);
        return Objects.equals(this.platformConfigurationId, other.platformConfigurationId) && Objects.equals(this.version, other.version) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.platformConfigurationId == null ? 43 : this.platformConfigurationId.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="platformConfigurationId")
        private String platformConfigurationId;
        @JsonProperty(value="version")
        private String version;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder platformConfigurationId(String platformConfigurationId) {
            this.platformConfigurationId = platformConfigurationId;
            this.__explicitlySet__.add("platformConfigurationId");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public PatchProduct build() {
            PatchProduct model = new PatchProduct(this.platformConfigurationId, this.version);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PatchProduct model) {
            if (model.wasPropertyExplicitlySet("platformConfigurationId")) {
                this.platformConfigurationId(model.getPlatformConfigurationId());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            return this;
        }
    }
}

