/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.ContentDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PlatformSpecificArtifact
extends ExplicitlySetBmcModel {
    @JsonProperty(value="content")
    private final ContentDetails content;
    @JsonProperty(value="osType")
    private final OsType osType;
    @JsonProperty(value="architecture")
    private final Architecture architecture;

    @Deprecated
    @ConstructorProperties(value={"content", "osType", "architecture"})
    public PlatformSpecificArtifact(ContentDetails content, OsType osType, Architecture architecture) {
        this.content = content;
        this.osType = osType;
        this.architecture = architecture;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ContentDetails getContent() {
        return this.content;
    }

    public OsType getOsType() {
        return this.osType;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PlatformSpecificArtifact(");
        sb.append("super=").append(super.toString());
        sb.append("content=").append(String.valueOf((Object)this.content));
        sb.append(", osType=").append(String.valueOf((Object)this.osType));
        sb.append(", architecture=").append(String.valueOf((Object)this.architecture));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlatformSpecificArtifact)) {
            return false;
        }
        PlatformSpecificArtifact other = (PlatformSpecificArtifact)((Object)o);
        return Objects.equals((Object)this.content, (Object)other.content) && Objects.equals((Object)this.osType, (Object)other.osType) && Objects.equals((Object)this.architecture, (Object)other.architecture) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.content == null ? 43 : this.content.hashCode());
        result = result * 59 + (this.osType == null ? 43 : this.osType.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Architecture implements BmcEnum
    {
        Arm64("ARM_64"),
        X64("X64"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Architecture> map;

        private Architecture(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Architecture create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Architecture', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Architecture.class);
            map = new HashMap<String, Architecture>();
            for (Architecture v : Architecture.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OsType implements BmcEnum
    {
        Windows("WINDOWS"),
        Linux("LINUX"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OsType> map;

        private OsType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OsType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OsType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OsType.class);
            map = new HashMap<String, OsType>();
            for (OsType v : OsType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="content")
        private ContentDetails content;
        @JsonProperty(value="osType")
        private OsType osType;
        @JsonProperty(value="architecture")
        private Architecture architecture;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder content(ContentDetails content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public Builder osType(OsType osType) {
            this.osType = osType;
            this.__explicitlySet__.add("osType");
            return this;
        }

        public Builder architecture(Architecture architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public PlatformSpecificArtifact build() {
            PlatformSpecificArtifact model = new PlatformSpecificArtifact(this.content, this.osType, this.architecture);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PlatformSpecificArtifact model) {
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            if (model.wasPropertyExplicitlySet("osType")) {
                this.osType(model.getOsType());
            }
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            return this;
        }
    }
}

