/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.ConfigAssociationDetails;
import com.oracle.bmc.fleetappsmanagement.model.ProductStackSubCategoryDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="subCategory")
@JsonFilter(value="explicitlySetFilter")
public final class ProductStackAsProductSubCategoryDetails
extends ProductStackSubCategoryDetails {
    @JsonProperty(value="versions")
    private final List<String> versions;
    @JsonProperty(value="credentials")
    private final List<ConfigAssociationDetails> credentials;
    @JsonProperty(value="components")
    private final List<String> components;
    @JsonProperty(value="patchTypes")
    private final List<ConfigAssociationDetails> patchTypes;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ProductStackAsProductSubCategoryDetails(List<String> versions, List<ConfigAssociationDetails> credentials, List<String> components, List<ConfigAssociationDetails> patchTypes) {
        this.versions = versions;
        this.credentials = credentials;
        this.components = components;
        this.patchTypes = patchTypes;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public List<ConfigAssociationDetails> getCredentials() {
        return this.credentials;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public List<ConfigAssociationDetails> getPatchTypes() {
        return this.patchTypes;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProductStackAsProductSubCategoryDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", versions=").append(String.valueOf(this.versions));
        sb.append(", credentials=").append(String.valueOf(this.credentials));
        sb.append(", components=").append(String.valueOf(this.components));
        sb.append(", patchTypes=").append(String.valueOf(this.patchTypes));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProductStackAsProductSubCategoryDetails)) {
            return false;
        }
        ProductStackAsProductSubCategoryDetails other = (ProductStackAsProductSubCategoryDetails)((Object)o);
        return Objects.equals(this.versions, other.versions) && Objects.equals(this.credentials, other.credentials) && Objects.equals(this.components, other.components) && Objects.equals(this.patchTypes, other.patchTypes) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.versions == null ? 43 : this.versions.hashCode());
        result = result * 59 + (this.credentials == null ? 43 : this.credentials.hashCode());
        result = result * 59 + (this.components == null ? 43 : this.components.hashCode());
        result = result * 59 + (this.patchTypes == null ? 43 : this.patchTypes.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="versions")
        private List<String> versions;
        @JsonProperty(value="credentials")
        private List<ConfigAssociationDetails> credentials;
        @JsonProperty(value="components")
        private List<String> components;
        @JsonProperty(value="patchTypes")
        private List<ConfigAssociationDetails> patchTypes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder versions(List<String> versions) {
            this.versions = versions;
            this.__explicitlySet__.add("versions");
            return this;
        }

        public Builder credentials(List<ConfigAssociationDetails> credentials) {
            this.credentials = credentials;
            this.__explicitlySet__.add("credentials");
            return this;
        }

        public Builder components(List<String> components) {
            this.components = components;
            this.__explicitlySet__.add("components");
            return this;
        }

        public Builder patchTypes(List<ConfigAssociationDetails> patchTypes) {
            this.patchTypes = patchTypes;
            this.__explicitlySet__.add("patchTypes");
            return this;
        }

        public ProductStackAsProductSubCategoryDetails build() {
            ProductStackAsProductSubCategoryDetails model = new ProductStackAsProductSubCategoryDetails(this.versions, this.credentials, this.components, this.patchTypes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProductStackAsProductSubCategoryDetails model) {
            if (model.wasPropertyExplicitlySet("versions")) {
                this.versions(model.getVersions());
            }
            if (model.wasPropertyExplicitlySet("credentials")) {
                this.credentials(model.getCredentials());
            }
            if (model.wasPropertyExplicitlySet("components")) {
                this.components(model.getComponents());
            }
            if (model.wasPropertyExplicitlySet("patchTypes")) {
                this.patchTypes(model.getPatchTypes());
            }
            return this;
        }
    }
}

