/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.ConfigAssociationDetails;
import com.oracle.bmc.fleetappsmanagement.model.ConfigCategoryDetails;
import com.oracle.bmc.fleetappsmanagement.model.ProductStackSubCategoryDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configCategory")
@JsonFilter(value="explicitlySetFilter")
public final class ProductStackConfigCategoryDetails
extends ConfigCategoryDetails {
    @JsonProperty(value="products")
    private final List<ConfigAssociationDetails> products;
    @JsonProperty(value="subCategoryDetails")
    private final ProductStackSubCategoryDetails subCategoryDetails;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ProductStackConfigCategoryDetails(List<ConfigAssociationDetails> products, ProductStackSubCategoryDetails subCategoryDetails) {
        this.products = products;
        this.subCategoryDetails = subCategoryDetails;
    }

    public List<ConfigAssociationDetails> getProducts() {
        return this.products;
    }

    public ProductStackSubCategoryDetails getSubCategoryDetails() {
        return this.subCategoryDetails;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProductStackConfigCategoryDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", products=").append(String.valueOf(this.products));
        sb.append(", subCategoryDetails=").append(String.valueOf((Object)this.subCategoryDetails));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProductStackConfigCategoryDetails)) {
            return false;
        }
        ProductStackConfigCategoryDetails other = (ProductStackConfigCategoryDetails)((Object)o);
        return Objects.equals(this.products, other.products) && Objects.equals((Object)this.subCategoryDetails, (Object)other.subCategoryDetails) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.products == null ? 43 : this.products.hashCode());
        result = result * 59 + (this.subCategoryDetails == null ? 43 : this.subCategoryDetails.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="products")
        private List<ConfigAssociationDetails> products;
        @JsonProperty(value="subCategoryDetails")
        private ProductStackSubCategoryDetails subCategoryDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder products(List<ConfigAssociationDetails> products) {
            this.products = products;
            this.__explicitlySet__.add("products");
            return this;
        }

        public Builder subCategoryDetails(ProductStackSubCategoryDetails subCategoryDetails) {
            this.subCategoryDetails = subCategoryDetails;
            this.__explicitlySet__.add("subCategoryDetails");
            return this;
        }

        public ProductStackConfigCategoryDetails build() {
            ProductStackConfigCategoryDetails model = new ProductStackConfigCategoryDetails(this.products, this.subCategoryDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProductStackConfigCategoryDetails model) {
            if (model.wasPropertyExplicitlySet("products")) {
                this.products(model.getProducts());
            }
            if (model.wasPropertyExplicitlySet("subCategoryDetails")) {
                this.subCategoryDetails(model.getSubCategoryDetails());
            }
            return this;
        }
    }
}

