/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.Condition;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Rule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="basis")
    private final String basis;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="resourceCompartmentId")
    private final String resourceCompartmentId;
    @JsonProperty(value="conditions")
    private final List<Condition> conditions;

    @Deprecated
    @ConstructorProperties(value={"basis", "compartmentId", "resourceCompartmentId", "conditions"})
    public Rule(String basis, String compartmentId, String resourceCompartmentId, List<Condition> conditions) {
        this.basis = basis;
        this.compartmentId = compartmentId;
        this.resourceCompartmentId = resourceCompartmentId;
        this.conditions = conditions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBasis() {
        return this.basis;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceCompartmentId() {
        return this.resourceCompartmentId;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Rule(");
        sb.append("super=").append(super.toString());
        sb.append("basis=").append(String.valueOf(this.basis));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", resourceCompartmentId=").append(String.valueOf(this.resourceCompartmentId));
        sb.append(", conditions=").append(String.valueOf(this.conditions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)((Object)o);
        return Objects.equals(this.basis, other.basis) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resourceCompartmentId, other.resourceCompartmentId) && Objects.equals(this.conditions, other.conditions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.basis == null ? 43 : this.basis.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resourceCompartmentId == null ? 43 : this.resourceCompartmentId.hashCode());
        result = result * 59 + (this.conditions == null ? 43 : this.conditions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="basis")
        private String basis;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="resourceCompartmentId")
        private String resourceCompartmentId;
        @JsonProperty(value="conditions")
        private List<Condition> conditions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder basis(String basis) {
            this.basis = basis;
            this.__explicitlySet__.add("basis");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder resourceCompartmentId(String resourceCompartmentId) {
            this.resourceCompartmentId = resourceCompartmentId;
            this.__explicitlySet__.add("resourceCompartmentId");
            return this;
        }

        public Builder conditions(List<Condition> conditions) {
            this.conditions = conditions;
            this.__explicitlySet__.add("conditions");
            return this;
        }

        public Rule build() {
            Rule model = new Rule(this.basis, this.compartmentId, this.resourceCompartmentId, this.conditions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Rule model) {
            if (model.wasPropertyExplicitlySet("basis")) {
                this.basis(model.getBasis());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("resourceCompartmentId")) {
                this.resourceCompartmentId(model.getResourceCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("conditions")) {
                this.conditions(model.getConditions());
            }
            return this;
        }
    }
}

