/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Schedule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="executionStartdate")
    private final Date executionStartdate;
    @JsonProperty(value="maintenanceWindowId")
    private final String maintenanceWindowId;
    @JsonProperty(value="recurrences")
    private final String recurrences;
    @JsonProperty(value="duration")
    private final String duration;

    @Deprecated
    @ConstructorProperties(value={"type", "executionStartdate", "maintenanceWindowId", "recurrences", "duration"})
    public Schedule(Type type, Date executionStartdate, String maintenanceWindowId, String recurrences, String duration) {
        this.type = type;
        this.executionStartdate = executionStartdate;
        this.maintenanceWindowId = maintenanceWindowId;
        this.recurrences = recurrences;
        this.duration = duration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Type getType() {
        return this.type;
    }

    public Date getExecutionStartdate() {
        return this.executionStartdate;
    }

    public String getMaintenanceWindowId() {
        return this.maintenanceWindowId;
    }

    public String getRecurrences() {
        return this.recurrences;
    }

    public String getDuration() {
        return this.duration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Schedule(");
        sb.append("super=").append(super.toString());
        sb.append("type=").append(String.valueOf((Object)this.type));
        sb.append(", executionStartdate=").append(String.valueOf(this.executionStartdate));
        sb.append(", maintenanceWindowId=").append(String.valueOf(this.maintenanceWindowId));
        sb.append(", recurrences=").append(String.valueOf(this.recurrences));
        sb.append(", duration=").append(String.valueOf(this.duration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)((Object)o);
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.executionStartdate, other.executionStartdate) && Objects.equals(this.maintenanceWindowId, other.maintenanceWindowId) && Objects.equals(this.recurrences, other.recurrences) && Objects.equals(this.duration, other.duration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.executionStartdate == null ? 43 : this.executionStartdate.hashCode());
        result = result * 59 + (this.maintenanceWindowId == null ? 43 : this.maintenanceWindowId.hashCode());
        result = result * 59 + (this.recurrences == null ? 43 : this.recurrences.hashCode());
        result = result * 59 + (this.duration == null ? 43 : this.duration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Custom("CUSTOM"),
        MaintenanceWindow("MAINTENANCE_WINDOW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="executionStartdate")
        private Date executionStartdate;
        @JsonProperty(value="maintenanceWindowId")
        private String maintenanceWindowId;
        @JsonProperty(value="recurrences")
        private String recurrences;
        @JsonProperty(value="duration")
        private String duration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder executionStartdate(Date executionStartdate) {
            this.executionStartdate = executionStartdate;
            this.__explicitlySet__.add("executionStartdate");
            return this;
        }

        public Builder maintenanceWindowId(String maintenanceWindowId) {
            this.maintenanceWindowId = maintenanceWindowId;
            this.__explicitlySet__.add("maintenanceWindowId");
            return this;
        }

        public Builder recurrences(String recurrences) {
            this.recurrences = recurrences;
            this.__explicitlySet__.add("recurrences");
            return this;
        }

        public Builder duration(String duration) {
            this.duration = duration;
            this.__explicitlySet__.add("duration");
            return this;
        }

        public Schedule build() {
            Schedule model = new Schedule(this.type, this.executionStartdate, this.maintenanceWindowId, this.recurrences, this.duration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Schedule model) {
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("executionStartdate")) {
                this.executionStartdate(model.getExecutionStartdate());
            }
            if (model.wasPropertyExplicitlySet("maintenanceWindowId")) {
                this.maintenanceWindowId(model.getMaintenanceWindowId());
            }
            if (model.wasPropertyExplicitlySet("recurrences")) {
                this.recurrences(model.getRecurrences());
            }
            if (model.wasPropertyExplicitlySet("duration")) {
                this.duration(model.getDuration());
            }
            return this;
        }
    }
}

