/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.LifeCycleActionGroupType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ScheduledFleetSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="tenancyId")
    private final String tenancyId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="countOfAffectedResources")
    private final Integer countOfAffectedResources;
    @JsonProperty(value="countOfAffectedTargets")
    private final Integer countOfAffectedTargets;
    @JsonProperty(value="actionGroupTypes")
    private final List<LifeCycleActionGroupType> actionGroupTypes;
    @JsonProperty(value="applicationTypes")
    private final List<String> applicationTypes;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "tenancyId", "displayName", "countOfAffectedResources", "countOfAffectedTargets", "actionGroupTypes", "applicationTypes", "systemTags"})
    public ScheduledFleetSummary(String id, String tenancyId, String displayName, Integer countOfAffectedResources, Integer countOfAffectedTargets, List<LifeCycleActionGroupType> actionGroupTypes, List<String> applicationTypes, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.tenancyId = tenancyId;
        this.displayName = displayName;
        this.countOfAffectedResources = countOfAffectedResources;
        this.countOfAffectedTargets = countOfAffectedTargets;
        this.actionGroupTypes = actionGroupTypes;
        this.applicationTypes = applicationTypes;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getCountOfAffectedResources() {
        return this.countOfAffectedResources;
    }

    public Integer getCountOfAffectedTargets() {
        return this.countOfAffectedTargets;
    }

    public List<LifeCycleActionGroupType> getActionGroupTypes() {
        return this.actionGroupTypes;
    }

    public List<String> getApplicationTypes() {
        return this.applicationTypes;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduledFleetSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", countOfAffectedResources=").append(String.valueOf(this.countOfAffectedResources));
        sb.append(", countOfAffectedTargets=").append(String.valueOf(this.countOfAffectedTargets));
        sb.append(", actionGroupTypes=").append(String.valueOf(this.actionGroupTypes));
        sb.append(", applicationTypes=").append(String.valueOf(this.applicationTypes));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledFleetSummary)) {
            return false;
        }
        ScheduledFleetSummary other = (ScheduledFleetSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.countOfAffectedResources, other.countOfAffectedResources) && Objects.equals(this.countOfAffectedTargets, other.countOfAffectedTargets) && Objects.equals(this.actionGroupTypes, other.actionGroupTypes) && Objects.equals(this.applicationTypes, other.applicationTypes) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.countOfAffectedResources == null ? 43 : this.countOfAffectedResources.hashCode());
        result = result * 59 + (this.countOfAffectedTargets == null ? 43 : this.countOfAffectedTargets.hashCode());
        result = result * 59 + (this.actionGroupTypes == null ? 43 : this.actionGroupTypes.hashCode());
        result = result * 59 + (this.applicationTypes == null ? 43 : this.applicationTypes.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="countOfAffectedResources")
        private Integer countOfAffectedResources;
        @JsonProperty(value="countOfAffectedTargets")
        private Integer countOfAffectedTargets;
        @JsonProperty(value="actionGroupTypes")
        private List<LifeCycleActionGroupType> actionGroupTypes;
        @JsonProperty(value="applicationTypes")
        private List<String> applicationTypes;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder countOfAffectedResources(Integer countOfAffectedResources) {
            this.countOfAffectedResources = countOfAffectedResources;
            this.__explicitlySet__.add("countOfAffectedResources");
            return this;
        }

        public Builder countOfAffectedTargets(Integer countOfAffectedTargets) {
            this.countOfAffectedTargets = countOfAffectedTargets;
            this.__explicitlySet__.add("countOfAffectedTargets");
            return this;
        }

        public Builder actionGroupTypes(List<LifeCycleActionGroupType> actionGroupTypes) {
            this.actionGroupTypes = actionGroupTypes;
            this.__explicitlySet__.add("actionGroupTypes");
            return this;
        }

        public Builder applicationTypes(List<String> applicationTypes) {
            this.applicationTypes = applicationTypes;
            this.__explicitlySet__.add("applicationTypes");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public ScheduledFleetSummary build() {
            ScheduledFleetSummary model = new ScheduledFleetSummary(this.id, this.tenancyId, this.displayName, this.countOfAffectedResources, this.countOfAffectedTargets, this.actionGroupTypes, this.applicationTypes, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScheduledFleetSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("tenancyId")) {
                this.tenancyId(model.getTenancyId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("countOfAffectedResources")) {
                this.countOfAffectedResources(model.getCountOfAffectedResources());
            }
            if (model.wasPropertyExplicitlySet("countOfAffectedTargets")) {
                this.countOfAffectedTargets(model.getCountOfAffectedTargets());
            }
            if (model.wasPropertyExplicitlySet("actionGroupTypes")) {
                this.actionGroupTypes(model.getActionGroupTypes());
            }
            if (model.wasPropertyExplicitlySet("applicationTypes")) {
                this.applicationTypes(model.getApplicationTypes());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

