/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.ConfigAssociationDetails;
import com.oracle.bmc.fleetappsmanagement.model.ContentDetails;
import com.oracle.bmc.fleetappsmanagement.model.ExecutionDetails;
import com.oracle.bmc.fleetappsmanagement.model.TaskVariable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="executionType")
@JsonFilter(value="explicitlySetFilter")
public final class ScriptBasedExecutionDetails
extends ExecutionDetails {
    @JsonProperty(value="variables")
    private final TaskVariable variables;
    @JsonProperty(value="content")
    private final ContentDetails content;
    @JsonProperty(value="command")
    private final String command;
    @JsonProperty(value="credentials")
    private final List<ConfigAssociationDetails> credentials;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ScriptBasedExecutionDetails(TaskVariable variables, ContentDetails content, String command, List<ConfigAssociationDetails> credentials) {
        this.variables = variables;
        this.content = content;
        this.command = command;
        this.credentials = credentials;
    }

    public TaskVariable getVariables() {
        return this.variables;
    }

    public ContentDetails getContent() {
        return this.content;
    }

    public String getCommand() {
        return this.command;
    }

    public List<ConfigAssociationDetails> getCredentials() {
        return this.credentials;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScriptBasedExecutionDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", variables=").append(String.valueOf((Object)this.variables));
        sb.append(", content=").append(String.valueOf((Object)this.content));
        sb.append(", command=").append(String.valueOf(this.command));
        sb.append(", credentials=").append(String.valueOf(this.credentials));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScriptBasedExecutionDetails)) {
            return false;
        }
        ScriptBasedExecutionDetails other = (ScriptBasedExecutionDetails)((Object)o);
        return Objects.equals((Object)this.variables, (Object)other.variables) && Objects.equals((Object)this.content, (Object)other.content) && Objects.equals(this.command, other.command) && Objects.equals(this.credentials, other.credentials) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.variables == null ? 43 : this.variables.hashCode());
        result = result * 59 + (this.content == null ? 43 : this.content.hashCode());
        result = result * 59 + (this.command == null ? 43 : this.command.hashCode());
        result = result * 59 + (this.credentials == null ? 43 : this.credentials.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="variables")
        private TaskVariable variables;
        @JsonProperty(value="content")
        private ContentDetails content;
        @JsonProperty(value="command")
        private String command;
        @JsonProperty(value="credentials")
        private List<ConfigAssociationDetails> credentials;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder variables(TaskVariable variables) {
            this.variables = variables;
            this.__explicitlySet__.add("variables");
            return this;
        }

        public Builder content(ContentDetails content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public Builder command(String command) {
            this.command = command;
            this.__explicitlySet__.add("command");
            return this;
        }

        public Builder credentials(List<ConfigAssociationDetails> credentials) {
            this.credentials = credentials;
            this.__explicitlySet__.add("credentials");
            return this;
        }

        public ScriptBasedExecutionDetails build() {
            ScriptBasedExecutionDetails model = new ScriptBasedExecutionDetails(this.variables, this.content, this.command, this.credentials);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScriptBasedExecutionDetails model) {
            if (model.wasPropertyExplicitlySet("variables")) {
                this.variables(model.getVariables());
            }
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            if (model.wasPropertyExplicitlySet("command")) {
                this.command(model.getCommand());
            }
            if (model.wasPropertyExplicitlySet("credentials")) {
                this.credentials(model.getCredentials());
            }
            return this;
        }
    }
}

