/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.AssociatedTaskDetails;
import com.oracle.bmc.fleetappsmanagement.model.ComponentProperties;
import com.oracle.bmc.fleetappsmanagement.model.OutputVariableMapping;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Task
extends ExplicitlySetBmcModel {
    @JsonProperty(value="stepName")
    private final String stepName;
    @JsonProperty(value="associationType")
    private final AssociationType associationType;
    @JsonProperty(value="taskRecordDetails")
    private final AssociatedTaskDetails taskRecordDetails;
    @JsonProperty(value="stepProperties")
    private final ComponentProperties stepProperties;
    @JsonProperty(value="outputVariableMappings")
    private final List<OutputVariableMapping> outputVariableMappings;

    @Deprecated
    @ConstructorProperties(value={"stepName", "associationType", "taskRecordDetails", "stepProperties", "outputVariableMappings"})
    public Task(String stepName, AssociationType associationType, AssociatedTaskDetails taskRecordDetails, ComponentProperties stepProperties, List<OutputVariableMapping> outputVariableMappings) {
        this.stepName = stepName;
        this.associationType = associationType;
        this.taskRecordDetails = taskRecordDetails;
        this.stepProperties = stepProperties;
        this.outputVariableMappings = outputVariableMappings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStepName() {
        return this.stepName;
    }

    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public AssociatedTaskDetails getTaskRecordDetails() {
        return this.taskRecordDetails;
    }

    public ComponentProperties getStepProperties() {
        return this.stepProperties;
    }

    public List<OutputVariableMapping> getOutputVariableMappings() {
        return this.outputVariableMappings;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Task(");
        sb.append("super=").append(super.toString());
        sb.append("stepName=").append(String.valueOf(this.stepName));
        sb.append(", associationType=").append(String.valueOf((Object)this.associationType));
        sb.append(", taskRecordDetails=").append(String.valueOf((Object)this.taskRecordDetails));
        sb.append(", stepProperties=").append(String.valueOf((Object)this.stepProperties));
        sb.append(", outputVariableMappings=").append(String.valueOf(this.outputVariableMappings));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)((Object)o);
        return Objects.equals(this.stepName, other.stepName) && Objects.equals((Object)this.associationType, (Object)other.associationType) && Objects.equals((Object)this.taskRecordDetails, (Object)other.taskRecordDetails) && Objects.equals((Object)this.stepProperties, (Object)other.stepProperties) && Objects.equals(this.outputVariableMappings, other.outputVariableMappings) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.stepName == null ? 43 : this.stepName.hashCode());
        result = result * 59 + (this.associationType == null ? 43 : this.associationType.hashCode());
        result = result * 59 + (this.taskRecordDetails == null ? 43 : this.taskRecordDetails.hashCode());
        result = result * 59 + (this.stepProperties == null ? 43 : this.stepProperties.hashCode());
        result = result * 59 + (this.outputVariableMappings == null ? 43 : this.outputVariableMappings.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AssociationType implements BmcEnum
    {
        Task("TASK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AssociationType> map;

        private AssociationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AssociationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AssociationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AssociationType.class);
            map = new HashMap<String, AssociationType>();
            for (AssociationType v : AssociationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stepName")
        private String stepName;
        @JsonProperty(value="associationType")
        private AssociationType associationType;
        @JsonProperty(value="taskRecordDetails")
        private AssociatedTaskDetails taskRecordDetails;
        @JsonProperty(value="stepProperties")
        private ComponentProperties stepProperties;
        @JsonProperty(value="outputVariableMappings")
        private List<OutputVariableMapping> outputVariableMappings;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stepName(String stepName) {
            this.stepName = stepName;
            this.__explicitlySet__.add("stepName");
            return this;
        }

        public Builder associationType(AssociationType associationType) {
            this.associationType = associationType;
            this.__explicitlySet__.add("associationType");
            return this;
        }

        public Builder taskRecordDetails(AssociatedTaskDetails taskRecordDetails) {
            this.taskRecordDetails = taskRecordDetails;
            this.__explicitlySet__.add("taskRecordDetails");
            return this;
        }

        public Builder stepProperties(ComponentProperties stepProperties) {
            this.stepProperties = stepProperties;
            this.__explicitlySet__.add("stepProperties");
            return this;
        }

        public Builder outputVariableMappings(List<OutputVariableMapping> outputVariableMappings) {
            this.outputVariableMappings = outputVariableMappings;
            this.__explicitlySet__.add("outputVariableMappings");
            return this;
        }

        public Task build() {
            Task model = new Task(this.stepName, this.associationType, this.taskRecordDetails, this.stepProperties, this.outputVariableMappings);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Task model) {
            if (model.wasPropertyExplicitlySet("stepName")) {
                this.stepName(model.getStepName());
            }
            if (model.wasPropertyExplicitlySet("associationType")) {
                this.associationType(model.getAssociationType());
            }
            if (model.wasPropertyExplicitlySet("taskRecordDetails")) {
                this.taskRecordDetails(model.getTaskRecordDetails());
            }
            if (model.wasPropertyExplicitlySet("stepProperties")) {
                this.stepProperties(model.getStepProperties());
            }
            if (model.wasPropertyExplicitlySet("outputVariableMappings")) {
                this.outputVariableMappings(model.getOutputVariableMappings());
            }
            return this;
        }
    }
}

