/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.ArtifactDetails;
import com.oracle.bmc.fleetappsmanagement.model.DependentPatchDetails;
import com.oracle.bmc.fleetappsmanagement.model.PatchProduct;
import com.oracle.bmc.fleetappsmanagement.model.PatchSeverity;
import com.oracle.bmc.fleetappsmanagement.model.PatchType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdatePatchDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="patchType")
    private final PatchType patchType;
    @JsonProperty(value="severity")
    private final PatchSeverity severity;
    @JsonProperty(value="timeReleased")
    private final Date timeReleased;
    @JsonProperty(value="artifactDetails")
    private final ArtifactDetails artifactDetails;
    @JsonProperty(value="product")
    private final PatchProduct product;
    @JsonProperty(value="dependentPatches")
    private final List<DependentPatchDetails> dependentPatches;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"description", "patchType", "severity", "timeReleased", "artifactDetails", "product", "dependentPatches", "compartmentId", "freeformTags", "definedTags"})
    public UpdatePatchDetails(String description, PatchType patchType, PatchSeverity severity, Date timeReleased, ArtifactDetails artifactDetails, PatchProduct product, List<DependentPatchDetails> dependentPatches, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.description = description;
        this.patchType = patchType;
        this.severity = severity;
        this.timeReleased = timeReleased;
        this.artifactDetails = artifactDetails;
        this.product = product;
        this.dependentPatches = dependentPatches;
        this.compartmentId = compartmentId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDescription() {
        return this.description;
    }

    public PatchType getPatchType() {
        return this.patchType;
    }

    public PatchSeverity getSeverity() {
        return this.severity;
    }

    public Date getTimeReleased() {
        return this.timeReleased;
    }

    public ArtifactDetails getArtifactDetails() {
        return this.artifactDetails;
    }

    public PatchProduct getProduct() {
        return this.product;
    }

    public List<DependentPatchDetails> getDependentPatches() {
        return this.dependentPatches;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdatePatchDetails(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", patchType=").append(String.valueOf((Object)this.patchType));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", timeReleased=").append(String.valueOf(this.timeReleased));
        sb.append(", artifactDetails=").append(String.valueOf((Object)this.artifactDetails));
        sb.append(", product=").append(String.valueOf((Object)this.product));
        sb.append(", dependentPatches=").append(String.valueOf(this.dependentPatches));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePatchDetails)) {
            return false;
        }
        UpdatePatchDetails other = (UpdatePatchDetails)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals((Object)this.patchType, (Object)other.patchType) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.timeReleased, other.timeReleased) && Objects.equals((Object)this.artifactDetails, (Object)other.artifactDetails) && Objects.equals((Object)this.product, (Object)other.product) && Objects.equals(this.dependentPatches, other.dependentPatches) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.patchType == null ? 43 : this.patchType.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.timeReleased == null ? 43 : this.timeReleased.hashCode());
        result = result * 59 + (this.artifactDetails == null ? 43 : this.artifactDetails.hashCode());
        result = result * 59 + (this.product == null ? 43 : this.product.hashCode());
        result = result * 59 + (this.dependentPatches == null ? 43 : this.dependentPatches.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="patchType")
        private PatchType patchType;
        @JsonProperty(value="severity")
        private PatchSeverity severity;
        @JsonProperty(value="timeReleased")
        private Date timeReleased;
        @JsonProperty(value="artifactDetails")
        private ArtifactDetails artifactDetails;
        @JsonProperty(value="product")
        private PatchProduct product;
        @JsonProperty(value="dependentPatches")
        private List<DependentPatchDetails> dependentPatches;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder patchType(PatchType patchType) {
            this.patchType = patchType;
            this.__explicitlySet__.add("patchType");
            return this;
        }

        public Builder severity(PatchSeverity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder timeReleased(Date timeReleased) {
            this.timeReleased = timeReleased;
            this.__explicitlySet__.add("timeReleased");
            return this;
        }

        public Builder artifactDetails(ArtifactDetails artifactDetails) {
            this.artifactDetails = artifactDetails;
            this.__explicitlySet__.add("artifactDetails");
            return this;
        }

        public Builder product(PatchProduct product) {
            this.product = product;
            this.__explicitlySet__.add("product");
            return this;
        }

        public Builder dependentPatches(List<DependentPatchDetails> dependentPatches) {
            this.dependentPatches = dependentPatches;
            this.__explicitlySet__.add("dependentPatches");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdatePatchDetails build() {
            UpdatePatchDetails model = new UpdatePatchDetails(this.description, this.patchType, this.severity, this.timeReleased, this.artifactDetails, this.product, this.dependentPatches, this.compartmentId, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdatePatchDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("patchType")) {
                this.patchType(model.getPatchType());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("timeReleased")) {
                this.timeReleased(model.getTimeReleased());
            }
            if (model.wasPropertyExplicitlySet("artifactDetails")) {
                this.artifactDetails(model.getArtifactDetails());
            }
            if (model.wasPropertyExplicitlySet("product")) {
                this.product(model.getProduct());
            }
            if (model.wasPropertyExplicitlySet("dependentPatches")) {
                this.dependentPatches(model.getDependentPatches());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

