/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fleetappsmanagement.model.WorkflowComponent;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkflowGroup
extends ExplicitlySetBmcModel {
    @JsonProperty(value="groupName")
    private final String groupName;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="steps")
    private final List<WorkflowComponent> steps;

    @Deprecated
    @ConstructorProperties(value={"groupName", "type", "steps"})
    public WorkflowGroup(String groupName, Type type, List<WorkflowComponent> steps) {
        this.groupName = groupName;
        this.type = type;
        this.steps = steps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Type getType() {
        return this.type;
    }

    public List<WorkflowComponent> getSteps() {
        return this.steps;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkflowGroup(");
        sb.append("super=").append(super.toString());
        sb.append("groupName=").append(String.valueOf(this.groupName));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", steps=").append(String.valueOf(this.steps));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkflowGroup)) {
            return false;
        }
        WorkflowGroup other = (WorkflowGroup)((Object)o);
        return Objects.equals(this.groupName, other.groupName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.steps, other.steps) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.groupName == null ? 43 : this.groupName.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.steps == null ? 43 : this.steps.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        ParallelResourceGroup("PARALLEL_RESOURCE_GROUP"),
        RollingResourceGroup("ROLLING_RESOURCE_GROUP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="groupName")
        private String groupName;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="steps")
        private List<WorkflowComponent> steps;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder groupName(String groupName) {
            this.groupName = groupName;
            this.__explicitlySet__.add("groupName");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder steps(List<WorkflowComponent> steps) {
            this.steps = steps;
            this.__explicitlySet__.add("steps");
            return this;
        }

        public WorkflowGroup build() {
            WorkflowGroup model = new WorkflowGroup(this.groupName, this.type, this.steps);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkflowGroup model) {
            if (model.wasPropertyExplicitlySet("groupName")) {
                this.groupName(model.getGroupName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("steps")) {
                this.steps(model.getSteps());
            }
            return this;
        }
    }
}

