/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCompliancePolicyRequest
extends BmcRequest<Void> {
    private String compliancePolicyId;
    private String opcRequestId;

    public String getCompliancePolicyId() {
        return this.compliancePolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compliancePolicyId(this.compliancePolicyId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compliancePolicyId=").append(String.valueOf(this.compliancePolicyId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCompliancePolicyRequest)) {
            return false;
        }
        GetCompliancePolicyRequest other = (GetCompliancePolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compliancePolicyId, other.compliancePolicyId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compliancePolicyId == null ? 43 : this.compliancePolicyId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCompliancePolicyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compliancePolicyId = null;
        private String opcRequestId = null;

        public Builder compliancePolicyId(String compliancePolicyId) {
            this.compliancePolicyId = compliancePolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCompliancePolicyRequest o) {
            this.compliancePolicyId(o.getCompliancePolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCompliancePolicyRequest build() {
            GetCompliancePolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCompliancePolicyRequest buildWithoutInvocationCallback() {
            GetCompliancePolicyRequest request = new GetCompliancePolicyRequest();
            request.compliancePolicyId = this.compliancePolicyId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

