/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCompliancePolicyRuleRequest
extends BmcRequest<Void> {
    private String compliancePolicyRuleId;
    private String opcRequestId;

    public String getCompliancePolicyRuleId() {
        return this.compliancePolicyRuleId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compliancePolicyRuleId(this.compliancePolicyRuleId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compliancePolicyRuleId=").append(String.valueOf(this.compliancePolicyRuleId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCompliancePolicyRuleRequest)) {
            return false;
        }
        GetCompliancePolicyRuleRequest other = (GetCompliancePolicyRuleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compliancePolicyRuleId, other.compliancePolicyRuleId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compliancePolicyRuleId == null ? 43 : this.compliancePolicyRuleId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCompliancePolicyRuleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compliancePolicyRuleId = null;
        private String opcRequestId = null;

        public Builder compliancePolicyRuleId(String compliancePolicyRuleId) {
            this.compliancePolicyRuleId = compliancePolicyRuleId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCompliancePolicyRuleRequest o) {
            this.compliancePolicyRuleId(o.getCompliancePolicyRuleId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCompliancePolicyRuleRequest build() {
            GetCompliancePolicyRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCompliancePolicyRuleRequest buildWithoutInvocationCallback() {
            GetCompliancePolicyRuleRequest request = new GetCompliancePolicyRuleRequest();
            request.compliancePolicyRuleId = this.compliancePolicyRuleId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

