/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExecutionRequest
extends BmcRequest<Void> {
    private String schedulerJobId;
    private String jobActivityId;
    private String resourceId;
    private String executionId;
    private String opcRequestId;

    public String getSchedulerJobId() {
        return this.schedulerJobId;
    }

    public String getJobActivityId() {
        return this.jobActivityId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().schedulerJobId(this.schedulerJobId).jobActivityId(this.jobActivityId).resourceId(this.resourceId).executionId(this.executionId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",schedulerJobId=").append(String.valueOf(this.schedulerJobId));
        sb.append(",jobActivityId=").append(String.valueOf(this.jobActivityId));
        sb.append(",resourceId=").append(String.valueOf(this.resourceId));
        sb.append(",executionId=").append(String.valueOf(this.executionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExecutionRequest)) {
            return false;
        }
        GetExecutionRequest other = (GetExecutionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.schedulerJobId, other.schedulerJobId) && Objects.equals(this.jobActivityId, other.jobActivityId) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.executionId, other.executionId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.schedulerJobId == null ? 43 : this.schedulerJobId.hashCode());
        result = result * 59 + (this.jobActivityId == null ? 43 : this.jobActivityId.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.executionId == null ? 43 : this.executionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExecutionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String schedulerJobId = null;
        private String jobActivityId = null;
        private String resourceId = null;
        private String executionId = null;
        private String opcRequestId = null;

        public Builder schedulerJobId(String schedulerJobId) {
            this.schedulerJobId = schedulerJobId;
            return this;
        }

        public Builder jobActivityId(String jobActivityId) {
            this.jobActivityId = jobActivityId;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExecutionRequest o) {
            this.schedulerJobId(o.getSchedulerJobId());
            this.jobActivityId(o.getJobActivityId());
            this.resourceId(o.getResourceId());
            this.executionId(o.getExecutionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExecutionRequest build() {
            GetExecutionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExecutionRequest buildWithoutInvocationCallback() {
            GetExecutionRequest request = new GetExecutionRequest();
            request.schedulerJobId = this.schedulerJobId;
            request.jobActivityId = this.jobActivityId;
            request.resourceId = this.resourceId;
            request.executionId = this.executionId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

