/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetFleetResourceRequest
extends BmcRequest<Void> {
    private String fleetResourceId;
    private String fleetId;
    private String opcRequestId;

    public String getFleetResourceId() {
        return this.fleetResourceId;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fleetResourceId(this.fleetResourceId).fleetId(this.fleetId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetResourceId=").append(String.valueOf(this.fleetResourceId));
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFleetResourceRequest)) {
            return false;
        }
        GetFleetResourceRequest other = (GetFleetResourceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetResourceId, other.fleetResourceId) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetResourceId == null ? 43 : this.fleetResourceId.hashCode());
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetFleetResourceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetResourceId = null;
        private String fleetId = null;
        private String opcRequestId = null;

        public Builder fleetResourceId(String fleetResourceId) {
            this.fleetResourceId = fleetResourceId;
            return this;
        }

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetFleetResourceRequest o) {
            this.fleetResourceId(o.getFleetResourceId());
            this.fleetId(o.getFleetId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetFleetResourceRequest build() {
            GetFleetResourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetFleetResourceRequest buildWithoutInvocationCallback() {
            GetFleetResourceRequest request = new GetFleetResourceRequest();
            request.fleetResourceId = this.fleetResourceId;
            request.fleetId = this.fleetId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

