/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMaintenanceWindowRequest
extends BmcRequest<Void> {
    private String maintenanceWindowId;
    private String opcRequestId;

    public String getMaintenanceWindowId() {
        return this.maintenanceWindowId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().maintenanceWindowId(this.maintenanceWindowId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",maintenanceWindowId=").append(String.valueOf(this.maintenanceWindowId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMaintenanceWindowRequest)) {
            return false;
        }
        GetMaintenanceWindowRequest other = (GetMaintenanceWindowRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.maintenanceWindowId, other.maintenanceWindowId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maintenanceWindowId == null ? 43 : this.maintenanceWindowId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMaintenanceWindowRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String maintenanceWindowId = null;
        private String opcRequestId = null;

        public Builder maintenanceWindowId(String maintenanceWindowId) {
            this.maintenanceWindowId = maintenanceWindowId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMaintenanceWindowRequest o) {
            this.maintenanceWindowId(o.getMaintenanceWindowId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMaintenanceWindowRequest build() {
            GetMaintenanceWindowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMaintenanceWindowRequest buildWithoutInvocationCallback() {
            GetMaintenanceWindowRequest request = new GetMaintenanceWindowRequest();
            request.maintenanceWindowId = this.maintenanceWindowId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

