/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.fleetappsmanagement.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListComplianceRecordsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String resourceId;
    private String entityId;
    private String productName;
    private String productStack;
    private String targetName;
    private String complianceState;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductStack() {
        return this.productStack;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getComplianceState() {
        return this.complianceState;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).resourceId(this.resourceId).entityId(this.entityId).productName(this.productName).productStack(this.productStack).targetName(this.targetName).complianceState(this.complianceState).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",resourceId=").append(String.valueOf(this.resourceId));
        sb.append(",entityId=").append(String.valueOf(this.entityId));
        sb.append(",productName=").append(String.valueOf(this.productName));
        sb.append(",productStack=").append(String.valueOf(this.productStack));
        sb.append(",targetName=").append(String.valueOf(this.targetName));
        sb.append(",complianceState=").append(String.valueOf(this.complianceState));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListComplianceRecordsRequest)) {
            return false;
        }
        ListComplianceRecordsRequest other = (ListComplianceRecordsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.entityId, other.entityId) && Objects.equals(this.productName, other.productName) && Objects.equals(this.productStack, other.productStack) && Objects.equals(this.targetName, other.targetName) && Objects.equals(this.complianceState, other.complianceState) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.entityId == null ? 43 : this.entityId.hashCode());
        result = result * 59 + (this.productName == null ? 43 : this.productName.hashCode());
        result = result * 59 + (this.productStack == null ? 43 : this.productStack.hashCode());
        result = result * 59 + (this.targetName == null ? 43 : this.targetName.hashCode());
        result = result * 59 + (this.complianceState == null ? 43 : this.complianceState.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListComplianceRecordsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String resourceId = null;
        private String entityId = null;
        private String productName = null;
        private String productStack = null;
        private String targetName = null;
        private String complianceState = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public Builder productStack(String productStack) {
            this.productStack = productStack;
            return this;
        }

        public Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public Builder complianceState(String complianceState) {
            this.complianceState = complianceState;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListComplianceRecordsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.resourceId(o.getResourceId());
            this.entityId(o.getEntityId());
            this.productName(o.getProductName());
            this.productStack(o.getProductStack());
            this.targetName(o.getTargetName());
            this.complianceState(o.getComplianceState());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListComplianceRecordsRequest build() {
            ListComplianceRecordsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListComplianceRecordsRequest buildWithoutInvocationCallback() {
            ListComplianceRecordsRequest request = new ListComplianceRecordsRequest();
            request.compartmentId = this.compartmentId;
            request.resourceId = this.resourceId;
            request.entityId = this.entityId;
            request.productName = this.productName;
            request.productStack = this.productStack;
            request.targetName = this.targetName;
            request.complianceState = this.complianceState;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

