/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.fleetappsmanagement.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListInventoryResourcesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String resourceCompartmentId;
    private String lifecycleState;
    private String displayName;
    private String resourceRegion;
    private List<String> definedTagEquals;
    private List<String> freeformTagEquals;
    private List<String> inventoryProperties;
    private String matchingCriteria;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceCompartmentId() {
        return this.resourceCompartmentId;
    }

    public String getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getResourceRegion() {
        return this.resourceRegion;
    }

    public List<String> getDefinedTagEquals() {
        return this.definedTagEquals;
    }

    public List<String> getFreeformTagEquals() {
        return this.freeformTagEquals;
    }

    public List<String> getInventoryProperties() {
        return this.inventoryProperties;
    }

    public String getMatchingCriteria() {
        return this.matchingCriteria;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).resourceCompartmentId(this.resourceCompartmentId).lifecycleState(this.lifecycleState).displayName(this.displayName).resourceRegion(this.resourceRegion).definedTagEquals(this.definedTagEquals).freeformTagEquals(this.freeformTagEquals).inventoryProperties(this.inventoryProperties).matchingCriteria(this.matchingCriteria).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",resourceCompartmentId=").append(String.valueOf(this.resourceCompartmentId));
        sb.append(",lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",resourceRegion=").append(String.valueOf(this.resourceRegion));
        sb.append(",definedTagEquals=").append(String.valueOf(this.definedTagEquals));
        sb.append(",freeformTagEquals=").append(String.valueOf(this.freeformTagEquals));
        sb.append(",inventoryProperties=").append(String.valueOf(this.inventoryProperties));
        sb.append(",matchingCriteria=").append(String.valueOf(this.matchingCriteria));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListInventoryResourcesRequest)) {
            return false;
        }
        ListInventoryResourcesRequest other = (ListInventoryResourcesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resourceCompartmentId, other.resourceCompartmentId) && Objects.equals(this.lifecycleState, other.lifecycleState) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.resourceRegion, other.resourceRegion) && Objects.equals(this.definedTagEquals, other.definedTagEquals) && Objects.equals(this.freeformTagEquals, other.freeformTagEquals) && Objects.equals(this.inventoryProperties, other.inventoryProperties) && Objects.equals(this.matchingCriteria, other.matchingCriteria) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resourceCompartmentId == null ? 43 : this.resourceCompartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.resourceRegion == null ? 43 : this.resourceRegion.hashCode());
        result = result * 59 + (this.definedTagEquals == null ? 43 : this.definedTagEquals.hashCode());
        result = result * 59 + (this.freeformTagEquals == null ? 43 : this.freeformTagEquals.hashCode());
        result = result * 59 + (this.inventoryProperties == null ? 43 : this.inventoryProperties.hashCode());
        result = result * 59 + (this.matchingCriteria == null ? 43 : this.matchingCriteria.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListInventoryResourcesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String resourceCompartmentId = null;
        private String lifecycleState = null;
        private String displayName = null;
        private String resourceRegion = null;
        private List<String> definedTagEquals = null;
        private List<String> freeformTagEquals = null;
        private List<String> inventoryProperties = null;
        private String matchingCriteria = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder resourceCompartmentId(String resourceCompartmentId) {
            this.resourceCompartmentId = resourceCompartmentId;
            return this;
        }

        public Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public Builder definedTagEquals(List<String> definedTagEquals) {
            this.definedTagEquals = definedTagEquals;
            return this;
        }

        public Builder definedTagEquals(String singularValue) {
            return this.definedTagEquals(Arrays.asList(singularValue));
        }

        public Builder freeformTagEquals(List<String> freeformTagEquals) {
            this.freeformTagEquals = freeformTagEquals;
            return this;
        }

        public Builder freeformTagEquals(String singularValue) {
            return this.freeformTagEquals(Arrays.asList(singularValue));
        }

        public Builder inventoryProperties(List<String> inventoryProperties) {
            this.inventoryProperties = inventoryProperties;
            return this;
        }

        public Builder inventoryProperties(String singularValue) {
            return this.inventoryProperties(Arrays.asList(singularValue));
        }

        public Builder matchingCriteria(String matchingCriteria) {
            this.matchingCriteria = matchingCriteria;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListInventoryResourcesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.resourceCompartmentId(o.getResourceCompartmentId());
            this.lifecycleState(o.getLifecycleState());
            this.displayName(o.getDisplayName());
            this.resourceRegion(o.getResourceRegion());
            this.definedTagEquals(o.getDefinedTagEquals());
            this.freeformTagEquals(o.getFreeformTagEquals());
            this.inventoryProperties(o.getInventoryProperties());
            this.matchingCriteria(o.getMatchingCriteria());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListInventoryResourcesRequest build() {
            ListInventoryResourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListInventoryResourcesRequest buildWithoutInvocationCallback() {
            ListInventoryResourcesRequest request = new ListInventoryResourcesRequest();
            request.compartmentId = this.compartmentId;
            request.resourceCompartmentId = this.resourceCompartmentId;
            request.lifecycleState = this.lifecycleState;
            request.displayName = this.displayName;
            request.resourceRegion = this.resourceRegion;
            request.definedTagEquals = this.definedTagEquals;
            request.freeformTagEquals = this.freeformTagEquals;
            request.inventoryProperties = this.inventoryProperties;
            request.matchingCriteria = this.matchingCriteria;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

