/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.fleetappsmanagement.model.Patch;
import com.oracle.bmc.fleetappsmanagement.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListPatchesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String productId;
    private String version;
    private Patch.Type type;
    private String patchTypeId;
    private String name;
    private String id;
    private Date timeReleasedGreaterThanOrEqualTo;
    private Date timeReleasedLessThan;
    private Boolean shouldCompliancePolicyRulesBeApplied;
    private Integer limit;
    private String page;
    private Patch.LifecycleState lifecycleState;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getVersion() {
        return this.version;
    }

    public Patch.Type getType() {
        return this.type;
    }

    public String getPatchTypeId() {
        return this.patchTypeId;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Date getTimeReleasedGreaterThanOrEqualTo() {
        return this.timeReleasedGreaterThanOrEqualTo;
    }

    public Date getTimeReleasedLessThan() {
        return this.timeReleasedLessThan;
    }

    public Boolean getShouldCompliancePolicyRulesBeApplied() {
        return this.shouldCompliancePolicyRulesBeApplied;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Patch.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).productId(this.productId).version(this.version).type(this.type).patchTypeId(this.patchTypeId).name(this.name).id(this.id).timeReleasedGreaterThanOrEqualTo(this.timeReleasedGreaterThanOrEqualTo).timeReleasedLessThan(this.timeReleasedLessThan).shouldCompliancePolicyRulesBeApplied(this.shouldCompliancePolicyRulesBeApplied).limit(this.limit).page(this.page).lifecycleState(this.lifecycleState).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",productId=").append(String.valueOf(this.productId));
        sb.append(",version=").append(String.valueOf(this.version));
        sb.append(",type=").append(String.valueOf((Object)this.type));
        sb.append(",patchTypeId=").append(String.valueOf(this.patchTypeId));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",timeReleasedGreaterThanOrEqualTo=").append(String.valueOf(this.timeReleasedGreaterThanOrEqualTo));
        sb.append(",timeReleasedLessThan=").append(String.valueOf(this.timeReleasedLessThan));
        sb.append(",shouldCompliancePolicyRulesBeApplied=").append(String.valueOf(this.shouldCompliancePolicyRulesBeApplied));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPatchesRequest)) {
            return false;
        }
        ListPatchesRequest other = (ListPatchesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.productId, other.productId) && Objects.equals(this.version, other.version) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.patchTypeId, other.patchTypeId) && Objects.equals(this.name, other.name) && Objects.equals(this.id, other.id) && Objects.equals(this.timeReleasedGreaterThanOrEqualTo, other.timeReleasedGreaterThanOrEqualTo) && Objects.equals(this.timeReleasedLessThan, other.timeReleasedLessThan) && Objects.equals(this.shouldCompliancePolicyRulesBeApplied, other.shouldCompliancePolicyRulesBeApplied) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.productId == null ? 43 : this.productId.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.patchTypeId == null ? 43 : this.patchTypeId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.timeReleasedGreaterThanOrEqualTo == null ? 43 : this.timeReleasedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeReleasedLessThan == null ? 43 : this.timeReleasedLessThan.hashCode());
        result = result * 59 + (this.shouldCompliancePolicyRulesBeApplied == null ? 43 : this.shouldCompliancePolicyRulesBeApplied.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPatchesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String productId = null;
        private String version = null;
        private Patch.Type type = null;
        private String patchTypeId = null;
        private String name = null;
        private String id = null;
        private Date timeReleasedGreaterThanOrEqualTo = null;
        private Date timeReleasedLessThan = null;
        private Boolean shouldCompliancePolicyRulesBeApplied = null;
        private Integer limit = null;
        private String page = null;
        private Patch.LifecycleState lifecycleState = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder type(Patch.Type type) {
            this.type = type;
            return this;
        }

        public Builder patchTypeId(String patchTypeId) {
            this.patchTypeId = patchTypeId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder timeReleasedGreaterThanOrEqualTo(Date timeReleasedGreaterThanOrEqualTo) {
            this.timeReleasedGreaterThanOrEqualTo = timeReleasedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeReleasedLessThan(Date timeReleasedLessThan) {
            this.timeReleasedLessThan = timeReleasedLessThan;
            return this;
        }

        public Builder shouldCompliancePolicyRulesBeApplied(Boolean shouldCompliancePolicyRulesBeApplied) {
            this.shouldCompliancePolicyRulesBeApplied = shouldCompliancePolicyRulesBeApplied;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder lifecycleState(Patch.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPatchesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.productId(o.getProductId());
            this.version(o.getVersion());
            this.type(o.getType());
            this.patchTypeId(o.getPatchTypeId());
            this.name(o.getName());
            this.id(o.getId());
            this.timeReleasedGreaterThanOrEqualTo(o.getTimeReleasedGreaterThanOrEqualTo());
            this.timeReleasedLessThan(o.getTimeReleasedLessThan());
            this.shouldCompliancePolicyRulesBeApplied(o.getShouldCompliancePolicyRulesBeApplied());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.lifecycleState(o.getLifecycleState());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPatchesRequest build() {
            ListPatchesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListPatchesRequest buildWithoutInvocationCallback() {
            ListPatchesRequest request = new ListPatchesRequest();
            request.compartmentId = this.compartmentId;
            request.productId = this.productId;
            request.version = this.version;
            request.type = this.type;
            request.patchTypeId = this.patchTypeId;
            request.name = this.name;
            request.id = this.id;
            request.timeReleasedGreaterThanOrEqualTo = this.timeReleasedGreaterThanOrEqualTo;
            request.timeReleasedLessThan = this.timeReleasedLessThan;
            request.shouldCompliancePolicyRulesBeApplied = this.shouldCompliancePolicyRulesBeApplied;
            request.limit = this.limit;
            request.page = this.page;
            request.lifecycleState = this.lifecycleState;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

