/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.fleetappsmanagement.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListResourcesRequest
extends BmcRequest<Void> {
    private String schedulerJobId;
    private String jobActivityId;
    private String resourceTaskId;
    private String stepName;
    private String targetName;
    private String sequence;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getSchedulerJobId() {
        return this.schedulerJobId;
    }

    public String getJobActivityId() {
        return this.jobActivityId;
    }

    public String getResourceTaskId() {
        return this.resourceTaskId;
    }

    public String getStepName() {
        return this.stepName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getSequence() {
        return this.sequence;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().schedulerJobId(this.schedulerJobId).jobActivityId(this.jobActivityId).resourceTaskId(this.resourceTaskId).stepName(this.stepName).targetName(this.targetName).sequence(this.sequence).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",schedulerJobId=").append(String.valueOf(this.schedulerJobId));
        sb.append(",jobActivityId=").append(String.valueOf(this.jobActivityId));
        sb.append(",resourceTaskId=").append(String.valueOf(this.resourceTaskId));
        sb.append(",stepName=").append(String.valueOf(this.stepName));
        sb.append(",targetName=").append(String.valueOf(this.targetName));
        sb.append(",sequence=").append(String.valueOf(this.sequence));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListResourcesRequest)) {
            return false;
        }
        ListResourcesRequest other = (ListResourcesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.schedulerJobId, other.schedulerJobId) && Objects.equals(this.jobActivityId, other.jobActivityId) && Objects.equals(this.resourceTaskId, other.resourceTaskId) && Objects.equals(this.stepName, other.stepName) && Objects.equals(this.targetName, other.targetName) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.schedulerJobId == null ? 43 : this.schedulerJobId.hashCode());
        result = result * 59 + (this.jobActivityId == null ? 43 : this.jobActivityId.hashCode());
        result = result * 59 + (this.resourceTaskId == null ? 43 : this.resourceTaskId.hashCode());
        result = result * 59 + (this.stepName == null ? 43 : this.stepName.hashCode());
        result = result * 59 + (this.targetName == null ? 43 : this.targetName.hashCode());
        result = result * 59 + (this.sequence == null ? 43 : this.sequence.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListResourcesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String schedulerJobId = null;
        private String jobActivityId = null;
        private String resourceTaskId = null;
        private String stepName = null;
        private String targetName = null;
        private String sequence = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder schedulerJobId(String schedulerJobId) {
            this.schedulerJobId = schedulerJobId;
            return this;
        }

        public Builder jobActivityId(String jobActivityId) {
            this.jobActivityId = jobActivityId;
            return this;
        }

        public Builder resourceTaskId(String resourceTaskId) {
            this.resourceTaskId = resourceTaskId;
            return this;
        }

        public Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public Builder sequence(String sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListResourcesRequest o) {
            this.schedulerJobId(o.getSchedulerJobId());
            this.jobActivityId(o.getJobActivityId());
            this.resourceTaskId(o.getResourceTaskId());
            this.stepName(o.getStepName());
            this.targetName(o.getTargetName());
            this.sequence(o.getSequence());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListResourcesRequest build() {
            ListResourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListResourcesRequest buildWithoutInvocationCallback() {
            ListResourcesRequest request = new ListResourcesRequest();
            request.schedulerJobId = this.schedulerJobId;
            request.jobActivityId = this.jobActivityId;
            request.resourceTaskId = this.resourceTaskId;
            request.stepName = this.stepName;
            request.targetName = this.targetName;
            request.sequence = this.sequence;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeStarted("timeStarted");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

