/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fleetappsmanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.fleetappsmanagement.model.ManageSettingsDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ManageSettingsRequest
extends BmcRequest<ManageSettingsDetails> {
    private String onboardingId;
    private ManageSettingsDetails manageSettingsDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getOnboardingId() {
        return this.onboardingId;
    }

    public ManageSettingsDetails getManageSettingsDetails() {
        return this.manageSettingsDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ManageSettingsDetails getBody$() {
        return this.manageSettingsDetails;
    }

    public Builder toBuilder() {
        return new Builder().onboardingId(this.onboardingId).manageSettingsDetails(this.manageSettingsDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",onboardingId=").append(String.valueOf(this.onboardingId));
        sb.append(",manageSettingsDetails=").append(String.valueOf((Object)this.manageSettingsDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManageSettingsRequest)) {
            return false;
        }
        ManageSettingsRequest other = (ManageSettingsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.onboardingId, other.onboardingId) && Objects.equals((Object)this.manageSettingsDetails, (Object)other.manageSettingsDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.onboardingId == null ? 43 : this.onboardingId.hashCode());
        result = result * 59 + (this.manageSettingsDetails == null ? 43 : this.manageSettingsDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ManageSettingsRequest, ManageSettingsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String onboardingId = null;
        private ManageSettingsDetails manageSettingsDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder onboardingId(String onboardingId) {
            this.onboardingId = onboardingId;
            return this;
        }

        public Builder manageSettingsDetails(ManageSettingsDetails manageSettingsDetails) {
            this.manageSettingsDetails = manageSettingsDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ManageSettingsRequest o) {
            this.onboardingId(o.getOnboardingId());
            this.manageSettingsDetails(o.getManageSettingsDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ManageSettingsRequest build() {
            ManageSettingsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ManageSettingsDetails body) {
            this.manageSettingsDetails(body);
            return this;
        }

        public ManageSettingsRequest buildWithoutInvocationCallback() {
            ManageSettingsRequest request = new ManageSettingsRequest();
            request.onboardingId = this.onboardingId;
            request.manageSettingsDetails = this.manageSettingsDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

